/*
 This file is part of GNU Taler
 (C) 2021-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 * @author Nic Eigel
 */
import {ErrorType, useTranslationContext} from "@gnu-taler/web-util/browser";
import {createHashHistory} from "history";
import {Fragment, VNode, h} from "preact";
import {Route, Router, route} from "preact-router";
import {useEffect, useErrorBoundary, useState} from "preact/hooks";
import {InstanceRoutes} from "./InstanceRoutes.js";
import {
    NotConnectedAppMenu,
    NotYetReadyAppMenu,
    NotificationCard,
} from "./components/menu/index.js";
import { useBackendContext, useBackendTokenContext } from "./context/backend.js";
import {Settings} from "./paths/settings/index.js";
import { useBackendConfig, useBackendToken } from "./hooks/backend.js";
import { Loading } from "./components/exception/loading.js";
import { LoginPage } from "./paths/login/index.js";

/**
 * Check if admin against /management/instances
 * @returns
 */
export function ApplicationReadyRoutes(): VNode {
    const {i18n} = useTranslationContext();
    const [unauthorized, setUnauthorized] = useState(false)
    const [backendToken, setToken] = useState(false)
    const { url: backendURL} = useBackendContext();
    const { token } = useBackendTokenContext();

    //TODO FIX bearer
    const result = useBackendToken();
    if (result.loading) return <Loading/>;
    if (!result.ok) {
        return (
          <LoginPage />
        );
    }
    const [showSettings, setShowSettings] = useState(false)

    if (showSettings) {
        return <Fragment>
            <NotYetReadyAppMenu onShowSettings={() => setShowSettings(true)} title="UI Settings"/>
            <Settings onClose={() => setShowSettings(false)}/>
        </Fragment>
    }

    const history = createHashHistory();
    return (
        <Router history={history}>
            <Route
                default
                component={DefaultMainRoute}
            />
        </Router>
    );
}

function DefaultMainRoute({
                              url, //from preact-router
                          }: any): VNode {
    //TODO
    url = "app/#" + url;

    return (
        <InstanceRoutes
            path={url}
        />
    );
}
