/*
 This file is part of GNU Anastasis
 (C) 2021-2022 Anastasis SARL

 GNU Anastasis is free software; you can redistribute it and/or modify it under the
 terms of the GNU Affero General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Anastasis is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License along with
 GNU Anastasis; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */
import { setupI18n } from "@gnu-taler/taler-util";
import { parseGroupImport } from "@gnu-taler/web-util/browser";
import * as tests from "@gnu-taler/web-util/testing";
import * as pages from "./pages/home/index.stories.js";
import { ComponentChildren, VNode, h as create } from "preact";
import { AnastasisProvider } from "./context/anastasis.js";
import { AnastasisReducerApi } from "./hooks/use-anastasis-reducer.js";
import { ReducerState } from "@gnu-taler/anastasis-core";

setupI18n("en", { en: {} });

describe("All the examples:", () => {
  const cms = parseGroupImport({ pages });
  cms.forEach((group) => {
    describe(`Example for group "${group.title}":`, () => {
      group.list.forEach((component) => {
        describe(`Component ${component.name}:`, () => {
          component.examples.forEach((example) => {
            it(`should render example: ${example.name}`, () => {
              tests.renderUI(example.render, DefaultTestingContext);
            });
          });
        });
      });
    });
  });
});

const noop = async (): Promise<void> => {
  return;
};

function DefaultTestingContext({
  children,
  ...rest
}: {
  children: ComponentChildren;
}): VNode {
  //some UI example can specify the state of the reducer
  const currentReducerState = rest as ReducerState;
  const value: AnastasisReducerApi = {
    currentReducerState,
    discoverMore: noop,
    discoverStart: noop,
    discoveryState: {
      state: "finished",
    },
    currentError: undefined,
    back: noop,
    dismissError: noop,
    reset: noop,
    runTransaction: noop,
    startBackup: noop,
    startRecover: noop,
    transition: noop,
    exportState: () => {
      return "{}";
    },
    importState: noop,
  };
  return create(AnastasisProvider, { value, children });
}
