# Spanish (es) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                           | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987º                                                     | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5º                                                        | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987º                                                     | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5º                                                        | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1º                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º                                                        | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | T1                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | T2                                                        | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1º trimestre                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º trimestre                                              | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                         | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1º                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º                                                        | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | T1                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | T2                                                        | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1º trimestre                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º trimestre                                              | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2º                                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7º                                                        | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | feb                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul                                                       | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | febrero                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | julio                                                     | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | f                                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | j                                                         | 2019-06-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2º                                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7º                                                        | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | feb                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul                                                       | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | febrero                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | julio                                                     | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | f                                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | j                                                         | 2019-06-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1º                                                        | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48º                                                       | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1º                                                        | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48º                                                       | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11º                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28º                                                       | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42º                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365º                                                      | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | lun                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vie                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | lun                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vie                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | lun                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vie                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | lunes                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | viernes                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | l                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | v                                                         | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | lu                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vi                                                        | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1º                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5º                                                        | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | lun                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vie                                                       | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | lunes                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | viernes                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | l                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | v                                                         | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | lu                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vi                                                        | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1º                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5º                                                        | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | lun                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vie                                                       | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | lunes                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | viernes                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | l                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | v                                                         | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | lu                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vi                                                        | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1º                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5º                                                        | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | lun                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vie                                                       | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | lunes                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | viernes                                                   | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | l                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | v                                                         | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | lu                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vi                                                        | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | am                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                        | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | a.m.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                      | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | a                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                         | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | am                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                        | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | a.m.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                      | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | a                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                         | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | de la mañana                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | de la tarde                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | de la tarde                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de la noche                                               | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | de la mañana                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | de la tarde                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | de la tarde                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de la noche                                               | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | de la mañana                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | de la tarde                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | de la tarde                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de la noche                                               | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | de la mañana                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | de la tarde                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | de la tarde                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de la noche                                               | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | de la mañana                                              | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | de la tarde                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | de la tarde                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de la noche                                               | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11º                                                       | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11º                                                       | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11º                                                       | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23º                                                       | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11º                                                       | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11º                                                       | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11º                                                       | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23º                                                       | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1º                                                        | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55º                                                       | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1º                                                        | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55º                                                       | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11/02/1987                                                | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                                | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 feb 1987                                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 may 1453                                               | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 de febrero de 1987                                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 de mayo de 1453                                        | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | miércoles, 11 de febrero de 1987                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | domingo, 29 de mayo de 1453                               | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                                     | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                     | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                                  | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                                  | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                            | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                            | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                        | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                        | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13                                         | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 23:59                                         | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 feb 1987, 12:13:14                                     | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 may 1453, 23:59:59                                     | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 de febrero de 1987 a las 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 de mayo de 1453 a las 23:59:59 GMT+0                   | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | miércoles, 11 de febrero de 1987 a las 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | domingo, 29 de mayo de 1453 a las 23:59:59 GMT+00:00      | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result               | `includeSeconds: true` | `addSuffix: true`         |
| ------------------------ | -------------------- | ---------------------- | ------------------------- |
| 2006-01-01T00:00:00.000Z | alrededor de 6 años  | alrededor de 6 años    | en alrededor de 6 años    |
| 2005-01-01T00:00:00.000Z | alrededor de 5 años  | alrededor de 5 años    | en alrededor de 5 años    |
| 2004-01-01T00:00:00.000Z | alrededor de 4 años  | alrededor de 4 años    | en alrededor de 4 años    |
| 2003-01-01T00:00:00.000Z | alrededor de 3 años  | alrededor de 3 años    | en alrededor de 3 años    |
| 2002-01-01T00:00:00.000Z | alrededor de 2 años  | alrededor de 2 años    | en alrededor de 2 años    |
| 2001-06-01T00:00:00.000Z | más de 1 año         | más de 1 año           | en más de 1 año           |
| 2001-02-01T00:00:00.000Z | alrededor de 1 año   | alrededor de 1 año     | en alrededor de 1 año     |
| 2001-01-01T00:00:00.000Z | alrededor de 1 año   | alrededor de 1 año     | en alrededor de 1 año     |
| 2000-06-01T00:00:00.000Z | 5 meses              | 5 meses                | en 5 meses                |
| 2000-03-01T00:00:00.000Z | 2 meses              | 2 meses                | en 2 meses                |
| 2000-02-01T00:00:00.000Z | alrededor de 1 mes   | alrededor de 1 mes     | en alrededor de 1 mes     |
| 2000-01-15T00:00:00.000Z | 14 días              | 14 días                | en 14 días                |
| 2000-01-02T00:00:00.000Z | 1 día                | 1 día                  | en 1 día                  |
| 2000-01-01T06:00:00.000Z | alrededor de 6 horas | alrededor de 6 horas   | en alrededor de 6 horas   |
| 2000-01-01T01:00:00.000Z | alrededor de 1 hora  | alrededor de 1 hora    | en alrededor de 1 hora    |
| 2000-01-01T00:45:00.000Z | alrededor de 1 hora  | alrededor de 1 hora    | en alrededor de 1 hora    |
| 2000-01-01T00:30:00.000Z | 30 minutos           | 30 minutos             | en 30 minutos             |
| 2000-01-01T00:15:00.000Z | 15 minutos           | 15 minutos             | en 15 minutos             |
| 2000-01-01T00:01:00.000Z | 1 minuto             | 1 minuto               | en 1 minuto               |
| 2000-01-01T00:00:25.000Z | menos de un minuto   | medio minuto           | en menos de un minuto     |
| 2000-01-01T00:00:15.000Z | menos de un minuto   | menos de 20 segundos   | en menos de un minuto     |
| 2000-01-01T00:00:05.000Z | menos de un minuto   | menos de 10 segundos   | en menos de un minuto     |
| 2000-01-01T00:00:00.000Z | menos de un minuto   | menos de 5 segundos    | hace menos de un minuto   |
| 1999-12-31T23:59:55.000Z | menos de un minuto   | menos de 10 segundos   | hace menos de un minuto   |
| 1999-12-31T23:59:45.000Z | menos de un minuto   | menos de 20 segundos   | hace menos de un minuto   |
| 1999-12-31T23:59:35.000Z | menos de un minuto   | medio minuto           | hace menos de un minuto   |
| 1999-12-31T23:59:00.000Z | 1 minuto             | 1 minuto               | hace 1 minuto             |
| 1999-12-31T23:45:00.000Z | 15 minutos           | 15 minutos             | hace 15 minutos           |
| 1999-12-31T23:30:00.000Z | 30 minutos           | 30 minutos             | hace 30 minutos           |
| 1999-12-31T23:15:00.000Z | alrededor de 1 hora  | alrededor de 1 hora    | hace alrededor de 1 hora  |
| 1999-12-31T23:00:00.000Z | alrededor de 1 hora  | alrededor de 1 hora    | hace alrededor de 1 hora  |
| 1999-12-31T18:00:00.000Z | alrededor de 6 horas | alrededor de 6 horas   | hace alrededor de 6 horas |
| 1999-12-30T00:00:00.000Z | 2 días               | 2 días                 | hace 2 días               |
| 1999-12-15T00:00:00.000Z | 17 días              | 17 días                | hace 17 días              |
| 1999-12-01T00:00:00.000Z | alrededor de 1 mes   | alrededor de 1 mes     | hace alrededor de 1 mes   |
| 1999-11-01T00:00:00.000Z | 2 meses              | 2 meses                | hace 2 meses              |
| 1999-06-01T00:00:00.000Z | 7 meses              | 7 meses                | hace 7 meses              |
| 1999-01-01T00:00:00.000Z | alrededor de 1 año   | alrededor de 1 año     | hace alrededor de 1 año   |
| 1998-12-01T00:00:00.000Z | alrededor de 1 año   | alrededor de 1 año     | hace alrededor de 1 año   |
| 1998-06-01T00:00:00.000Z | más de 1 año         | más de 1 año           | hace más de 1 año         |
| 1998-01-01T00:00:00.000Z | alrededor de 2 años  | alrededor de 2 años    | hace alrededor de 2 años  |
| 1997-01-01T00:00:00.000Z | alrededor de 3 años  | alrededor de 3 años    | hace alrededor de 3 años  |
| 1996-01-01T00:00:00.000Z | alrededor de 4 años  | alrededor de 4 años    | hace alrededor de 4 años  |
| 1995-01-01T00:00:00.000Z | alrededor de 5 años  | alrededor de 5 años    | hace alrededor de 5 años  |
| 1994-01-01T00:00:00.000Z | alrededor de 6 años  | alrededor de 6 años    | hace alrededor de 6 años  |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 años      | en 6 años         | 52608 horas                    |
| 2005-01-01T00:00:00.000Z | 5 años      | en 5 años         | 43848 horas                    |
| 2004-01-01T00:00:00.000Z | 4 años      | en 4 años         | 35064 horas                    |
| 2003-01-01T00:00:00.000Z | 3 años      | en 3 años         | 26304 horas                    |
| 2002-01-01T00:00:00.000Z | 2 años      | en 2 años         | 17544 horas                    |
| 2001-06-01T00:00:00.000Z | 1 año       | en 1 año          | 12408 horas                    |
| 2001-02-01T00:00:00.000Z | 1 año       | en 1 año          | 9528 horas                     |
| 2001-01-01T00:00:00.000Z | 1 año       | en 1 año          | 8784 horas                     |
| 2000-06-01T00:00:00.000Z | 5 meses     | en 5 meses        | 3648 horas                     |
| 2000-03-01T00:00:00.000Z | 2 meses     | en 2 meses        | 1440 horas                     |
| 2000-02-01T00:00:00.000Z | 1 mes       | en 1 mes          | 744 horas                      |
| 2000-01-15T00:00:00.000Z | 14 días     | en 14 días        | 336 horas                      |
| 2000-01-02T00:00:00.000Z | 1 día       | en 1 día          | 24 horas                       |
| 2000-01-01T06:00:00.000Z | 6 horas     | en 6 horas        | 6 horas                        |
| 2000-01-01T01:00:00.000Z | 1 hora      | en 1 hora         | 1 hora                         |
| 2000-01-01T00:45:00.000Z | 45 minutos  | en 45 minutos     | 1 hora                         |
| 2000-01-01T00:30:00.000Z | 30 minutos  | en 30 minutos     | 1 hora                         |
| 2000-01-01T00:15:00.000Z | 15 minutos  | en 15 minutos     | 0 horas                        |
| 2000-01-01T00:01:00.000Z | 1 minuto    | en 1 minuto       | 0 horas                        |
| 2000-01-01T00:00:25.000Z | 25 segundos | en 25 segundos    | 0 horas                        |
| 2000-01-01T00:00:15.000Z | 15 segundos | en 15 segundos    | 0 horas                        |
| 2000-01-01T00:00:05.000Z | 5 segundos  | en 5 segundos     | 0 horas                        |
| 2000-01-01T00:00:00.000Z | 0 segundos  | hace 0 segundos   | 0 horas                        |
| 1999-12-31T23:59:55.000Z | 5 segundos  | hace 5 segundos   | 0 horas                        |
| 1999-12-31T23:59:45.000Z | 15 segundos | hace 15 segundos  | 0 horas                        |
| 1999-12-31T23:59:35.000Z | 25 segundos | hace 25 segundos  | 0 horas                        |
| 1999-12-31T23:59:00.000Z | 1 minuto    | hace 1 minuto     | 0 horas                        |
| 1999-12-31T23:45:00.000Z | 15 minutos  | hace 15 minutos   | 0 horas                        |
| 1999-12-31T23:30:00.000Z | 30 minutos  | hace 30 minutos   | 1 hora                         |
| 1999-12-31T23:15:00.000Z | 45 minutos  | hace 45 minutos   | 1 hora                         |
| 1999-12-31T23:00:00.000Z | 1 hora      | hace 1 hora       | 1 hora                         |
| 1999-12-31T18:00:00.000Z | 6 horas     | hace 6 horas      | 6 horas                        |
| 1999-12-30T00:00:00.000Z | 2 días      | hace 2 días       | 48 horas                       |
| 1999-12-15T00:00:00.000Z | 17 días     | hace 17 días      | 408 horas                      |
| 1999-12-01T00:00:00.000Z | 1 mes       | hace 1 mes        | 744 horas                      |
| 1999-11-01T00:00:00.000Z | 2 meses     | hace 2 meses      | 1464 horas                     |
| 1999-06-01T00:00:00.000Z | 7 meses     | hace 7 meses      | 5136 horas                     |
| 1999-01-01T00:00:00.000Z | 1 año       | hace 1 año        | 8760 horas                     |
| 1998-12-01T00:00:00.000Z | 1 año       | hace 1 año        | 9504 horas                     |
| 1998-06-01T00:00:00.000Z | 2 años      | hace 2 años       | 13896 horas                    |
| 1998-01-01T00:00:00.000Z | 2 años      | hace 2 años       | 17520 horas                    |
| 1997-01-01T00:00:00.000Z | 3 años      | hace 3 años       | 26280 horas                    |
| 1996-01-01T00:00:00.000Z | 4 años      | hace 4 años       | 35064 horas                    |
| 1995-01-01T00:00:00.000Z | 5 años      | hace 5 años       | 43824 horas                    |
| 1994-01-01T00:00:00.000Z | 6 años      | hace 6 años       | 52584 horas                    |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                      |
| ------------------------ | --------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                  |
| 2000-01-05T00:00:00.000Z | miércoles a las 00:00       |
| 2000-01-02T00:00:00.000Z | mañana a las 00:00          |
| 2000-01-01T00:00:00.000Z | hoy a las 00:00             |
| 1999-12-31T00:00:00.000Z | ayer a las 00:00            |
| 1999-12-27T00:00:00.000Z | el lunes pasado a las 00:00 |
| 1999-12-21T00:00:00.000Z | 21/12/1999                  |
