/*
  This file is part of TALER
  Copyright (C) 2024 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU Affero General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file taler-merchant-httpd_private-post-donau-instance.h
 * @brief implementation of POST /donau
 * @author Bohdan Potuzhnyi
 * @author Vlada Svirsh
 */

#ifndef TALER_MERCHANT_HTTPD_POST_DONAU_INSTANCE_H
#define TALER_MERCHANT_HTTPD_POST_DONAU_INSTANCE_H

#include "taler-merchant-httpd.h"


/**
 * Resume all connections suspended on Donau-interaction during shutdown.
 */
void
TMH_force_post_donau_resume (void);


/**
 * Handle a POST "/donau" request.
 *
 * @param rh context of the handler
 * @param connection the MHD connection to handle
 * @param[in,out] hc context with further information about the request
 * @return MHD result code
 */
MHD_RESULT
TMH_private_post_donau_instance (const struct TMH_RequestHandler *rh,
                                 struct MHD_Connection *connection,
                                 struct TMH_HandlerContext *hc);

#endif
