/* miktex.h
   Time-stamp: "97/08/12 20:31:02 mik"

   Copyright (C) 1991, 92, 93, 94, 95, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#if ! defined (_MIKTEX_H)
#define _MIKTEX_H

#ifdef DEBUG
#include <assert.h>
#define xassert(e) assert(e)
#else
#define xassert(e) ((void) 0)
#endif

#include <stdio.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef NO_C4P
#  include "c4plib.h"
#endif

#if defined (_WIN32)

#  if defined (MIKTEX_DLL)
#    if defined (IN_MIKTEX_DLL)
#      define _MIKTEX_1 __declspec (dllexport)
#    else /* ! IN_MIKTEX_DLL */
#      define _MIKTEX_1 __declspec (dllimport)
#    endif /* ! IN_MIKTEX_DLL */
#  endif /* MIKTEX_DLL */

#  define _MIKTEX_2 __stdcall

#endif /* _WIN32 */

#if ! defined (_MIKTEX_1)
#  define _MIKTEX_1
#endif /* ! _MIKTEX_1 */

#if ! defined (_MIKTEX_2)
#  define _MIKTEX_2
#endif /* ! _MIKTEX_2 */

/* _________________________________________________________________________

   CONSTANTS.
   _________________________________________________________________________ */


/* fixme: shouldn't be fixed. */
#define MAX_TEXMF_ROOT_DIRECTORIES 10

/* _________________________________________________________________________

   TYPES.
   _________________________________________________________________________ */


typedef struct
{
  char *	mnemonic;
  char *	description;
  int		hor_res;
  int		vert_res;
} mf_mode;

/* _________________________________________________________________________

   FUNCTION PROTOTYPES.
   _________________________________________________________________________ */


_MIKTEX_1 int _MIKTEX_2
access_directory (const char *, int);

_MIKTEX_1 int _MIKTEX_2
access_regular_file (const char *, int);

_MIKTEX_1 int _MIKTEX_2
enter_temporary_directory (const char *, int);

_MIKTEX_1 void _MIKTEX_2
fatal_error (const char *fmt, ...);

_MIKTEX_1 int _MIKTEX_2
find_executable (const char *, char * );

_MIKTEX_1 int _MIKTEX_2
find_file (const char *, const char *, char *);

_MIKTEX_1 int _MIKTEX_2
find_pk_file (const char *, const char *, int, char *);

_MIKTEX_1 char * _MIKTEX_2
get_cfg_value (const char *, const char *, char *, size_t, char *);

_MIKTEX_1 int _MIKTEX_2
get_font_info (const char *, char *, char *);

_MIKTEX_1 char * _MIKTEX_2
get_home_directory (char *);

_MIKTEX_1 int _MIKTEX_2
get_metafont_modes (mf_mode *modes, size_t);

_MIKTEX_1 size_t _MIKTEX_2
get_number_of_texmf_roots ();

_MIKTEX_1 const char * _MIKTEX_2
get_root_directory (size_t);

_MIKTEX_1 char * _MIKTEX_2
get_search_path (const char *,const char *, char *, size_t, char *);

_MIKTEX_1 void _MIKTEX_2
leave_temporary_directory ();

_MIKTEX_1 int _MIKTEX_2
make_path (const char *);

_MIKTEX_1 int _MIKTEX_2
make_path_ex (const char *, int);

_MIKTEX_1 int _MIKTEX_2
make_pk_font (const char *, int, int, const char *);

_MIKTEX_1 void _MIKTEX_2
mtafterinit (void);

_MIKTEX_1 void _MIKTEX_2
mtfirstword (void);

_MIKTEX_1 void _MIKTEX_2
mtlastword (void);

_MIKTEX_1 FILE * _MIKTEX_2
open_file (const char *, const char *);

_MIKTEX_1 void _MIKTEX_2
parse_web_filename (char *, char **, char **, char **);

_MIKTEX_1 int _MIKTEX_2
set_metafont_mode (const mf_mode *);

#ifndef NO_C4P

#define istermin(f) ((f) -> _c4p_fp == input._c4p_fp)

_MIKTEX_1 int _MIKTEX_2
mtopentfmfil (_c4p_bytefile_t *, char *);

_MIKTEX_1 int _MIKTEX_2
mtopenvffile (_c4p_bytefile_t *, char *);

_MIKTEX_1 void _MIKTEX_2
miktexbanner (_c4p_textfile_t *);

#endif /* ! NO_C4P */

#ifdef __cplusplus
}
#endif

#endif /* _MIKTEX_H */

/* miktex.h ends here */
