#include "config.h"
#ifdef PAM_SMB_DAEMON
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <unistd.h>
#include <syslog.h>
#include <time.h>
#include "smblib.h"
#include "pam_smb_queue.h"

#include <errno.h>

int queue_user(char *username,char *password, char *domain)
{
  key_t key=PAMSMBKEY;
  pid_t cli_pid;
  int mid, n;
  MESSAGE msg;
  time_t start_time, now_time;

  cli_pid = getpid();

  if ((mid=msgget(key, 0)) == -1)
    {
      syslog(LOG_AUTHPRIV | LOG_ERR, "pamsmbd is not running, no authentication possible");
      return 2;
    }

  msg.msg_to=SERVER;
  msg.msg_fm=cli_pid;
  msg.return_code=2;
  strncpy(msg.username, username, 15);
  strncpy(msg.password, password, 15);
  strncpy(msg.domain, domain, 15);

  if(msgsnd(mid, (struct msgbuf *)&msg, sizeof(msg),  0) == -1)
    {
    syslog(LOG_AUTHPRIV | LOG_ERR, "pamsmbd : msg_snd problem");
    return 2;
    }

  start_time=time(NULL);
  
  for(;;)
    {
      if((n=msgrcv(mid, (struct msgbuf *)&msg, sizeof(msg), cli_pid, IPC_NOWAIT)) != -1 )
	{
	  /* fprintf(stderr, "Got something back... %d", msg.return_code); */
	  strncpy(username, msg.username, 15);
	  return(msg.return_code);
	}
      else
	{
	  switch(errno)
	    {
	    case EIDRM:
	      syslog(LOG_AUTHPRIV | LOG_ERR, "pamsmbm: server finished..\n");
	      return 2;
	      break;
	    default:
	    case EINTR:
	      syslog(LOG_AUTHPRIV | LOG_ERR, "pamsmbm: caught signal..\n");
	      return 2;
	      break;
	    case ENOMSG:
	      now_time=time(NULL);
	      if ((now_time-start_time)>PAMSMB_SERVERTIMEOUT)
		{
		  syslog(LOG_AUTHPRIV | LOG_ERR, "pamsmbm: no server...\n");
		  return 2;
		}
	    }
	}
    }
}
#else
void dummy_function_queue_valid(void) { } /* stops some compilers complaining */
#endif
