#include <stdio.h>
#include <string.h>

#include "cache.h"

#define CONFFILE "/etc/pam_smb.conf"

/***********************************************************************
	This file is (C) Dave Airlie 1997 ( David.Airlie@ul.ie ) 
	and is covered by the GPL provided in the COPYING FILE.
***********************************************************************/
int smb_readpamconf(domain_list *);

/****************************************************************************
 Read pam_smb configuration file.
****************************************************************************/
int smb_readpamconf(domain_list *pamsmb_dlist)
{
	FILE *fl;
	char buf[255], *p1;
	char *cr0;
	int len, count=0, scount=0;

	if (!(fl=fopen(CONFFILE,"r")))
	{
		return 1;
	}
	
	fgets(buf, 255, fl); 
	
	/* Check for a , in the string, if one then new style file,
	   if not then old style */

	p1=strchr(buf, ',');
	if (p1==NULL)
	  {
	    strncpy(pamsmb_dlist->controllers[0].domain, buf, 39);
	    cr0=strchr(pamsmb_dlist->controllers[0].domain, '\n');
	    if (cr0 != NULL)
	      *cr0 = '\0';
	    pamsmb_dlist->controllers[0].domain[39]='\0';
	    fgets(pamsmb_dlist->controllers[0].servers[0].sername, 40, fl);
	    cr0=strchr(pamsmb_dlist->controllers[0].servers[0].sername, '\n');
            if (cr0 != NULL)
	      *cr0 = '\0';
	    pamsmb_dlist->controllers[0].servers[0].sername[39]='\0';
	    fgets(pamsmb_dlist->controllers[0].servers[1].sername, 40, fl);
	    cr0=strchr(pamsmb_dlist->controllers[0].servers[1].sername, '\n');
            if (cr0 != NULL)
	      *cr0 = '\0';
	    pamsmb_dlist->controllers[0].servers[1].sername[39]='\0';
	  }
	else
	  {
	    do 
	      {
	    p1=strtok(buf, ",");
	    strncpy(pamsmb_dlist->controllers[count].domain,p1,39);
	    while ((p1=strtok(NULL, ",")) != NULL)
	      {
		strncpy(pamsmb_dlist->controllers[count].servers[scount].sername,p1,39);
		scount++;
	      }
	    pamsmb_dlist->controllers[count].numservers=scount;
	    count++;
	      } while (!feof(fl) && fgets(buf, 255,fl));
	    pamsmb_dlist->numdomains=count;
	  }
	fclose(fl);
	return(0);
}

