/*
 * This file is Copyright(C) Andrew Speer, 1998.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, and the entire permission notice in its entirety,
 *    including the disclaimer of warranties.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 * 
 * ALTERNATIVELY, this product may be distributed under the terms of
 * the GNU Public License, in which case the provisions of the GPL are
 * required INSTEAD OF the above restrictions.  (This clause is
 * necessary due to a potential bad interaction between the GPL and
 * the restrictions contained in a BSD-style copyright.)
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/* Slight changes by Dave Airlie (airlied@linux.ie)
	to integrate with configure */
/* Added mapvalid function to this file as it fits here */

#include "config.h"

#define  USERDB	"/etc/ntmap.db"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>            
#include <limits.h>     

#ifdef USE_DB2
#include <db_185.h>
#else
#include <db.h>
#endif

#include <fcntl.h> 
#include <ctype.h>

#include "cache.h"

int pam_map_user(usercache_data *user) {

	/*	Set up vars used in this routine. DB* values are
		supplied in db.h header */
	
	char	*lc;
	int		flags ;
	int		mode ;
	int 	res;
	int		type;
	DB		*db;
	DBT		key;
	DBT		value;

	char	dbname[100]=USERDB;
	char	nt_username[30]= "nt2unix.";
	char	ux_username[30]= "unix2nt.";
	char	nt_domainmap[30]= "domain.";
	char	buf[100];
	char	*buf_ptr=buf;
	char	*ret;
	/* char	nt_domain[30];*/
	const	char delim[2]=",";
	
	/*  Set the DB type to be a hash. Could be anything but hash
		is the type of db used by sendmail by default, so we may
		as well use that also */
		
	type =	DB_HASH;
	flags=	O_RDONLY;
	mode =	0;
	
	/*  Copy in the name supplied to pam_smb and lowercase it */

	strcat(nt_username,user->nt_user);
	lc=nt_username;
	
	while (*lc != '\0') {
		*lc=tolower(*lc);
		lc++;
	}
	lc++; *lc=0;
	
	strcat(ux_username,user->ux_user);
	lc=ux_username;
	
	while (*lc != '\0') {
		*lc=tolower(*lc);
		lc++;
	}
	lc++; *lc=0;
	
	/*  Main event. Open up the db file, return empty handed if
		dbopen fails. This leaves the nt name exactly as it 
		started */
	db = dbopen(dbname, flags, mode, type, NULL);
	if (db==NULL) { return; };
	

	/*	Load up the key structure with the nt_name as supplied by PAM. We
		want to translate this into the Unix name */
	
	key.data=nt_username;
	key.size=strlen(nt_username)+1;

	
	/*  Now get the value for uxuid, using the ntusername as the
		key. The returned data is the uxuid */
		
	res=(db->get)(db, &key, &value,0);
	
	if (res==0) {
	
		/*	Successful lookup. Overwrite the unix name use by pam_smb with the
			value supplied in the nt->ux name map */
		
	    strcpy(buf,value.data);
	    
	    /*  Try to get the domain (sep from name by comma), or else set to
	    	"default" */
	    	
	    strsep(&buf_ptr,(const char *)&delim);
	    if ((int)buf_ptr) {
		    strcpy(user->ux_user,buf);
		    strcpy(user->mx_domain,buf_ptr);
		}
		else {
			strcpy(user->ux_user,buf);
			strcpy(user->mx_domain,"default");
		}
		
	}
	
	/*  Now the case where we might have an app that cant support the possibly 'longer'
		NT names, so the user puts in their Unix name. We can use this, but want to 
		translate it back to an NT name if possible */
	
	key.data=ux_username;
	key.size=strlen(ux_username)+1;
		
	res=(db->get)(db, &key, &value,0);
	
	if (res==0) {
	
		/*	Successful lookup. Overwrite the name used by pam_smb with the
			value supplied in the nt->ux name map */
			
	    strcpy(buf,value.data);

	    /*  Try to get the domain (sep from name by comma), or else set to
	    	"default" */
	    	
	    strsep(&buf_ptr,(const char *)&delim);
	    if ((int)buf_ptr) {
		    strcpy(user->nt_user,buf);
		    strcpy(user->mx_domain,buf_ptr);
		}
		else {
			strcpy(user->nt_user,buf);
			strcpy(user->mx_domain,"default");
		}
	    
	}



	/*	OK, we have loaded up the domain name. Now get the pdc, and bdc
		settings for this domain from the map file */
	
	strcpy(key.data,"domain.");
	strcat(key.data,user->mx_domain);
	key.size=strlen(key.data)+1;
	
	res=(db->get)(db, &key, &value,0);
	
	if (res==0) {
	
		/*  Successfull domain lookup. Now parse out the values from
			returned string */
			
		strcpy(buf,value.data); 
		buf_ptr=buf;

		(int)buf_ptr=strtok(buf_ptr,(const char *)&delim);
		if (buf_ptr) {
			strcpy(user->nt_domain,buf_ptr);
		}
		(int)buf_ptr=strtok(NULL,(const char *)&delim);
		if (buf_ptr) {
			strcpy(user->pdc_nbname,buf_ptr);
		}
		(int)buf_ptr=strtok(NULL,(const char *)&delim);
		if (buf_ptr) {
			strcpy(user->pdc_hostname,buf_ptr);
		}
		(int)buf_ptr=strtok(NULL,(const char *)&delim);
		if (buf_ptr) {
			strcpy(user->bdc_nbname,buf_ptr);
		}
		(int)buf_ptr=strtok(NULL,(const char *)&delim);
		if (buf_ptr) {
			strcpy(user->bdc_hostname,buf_ptr);
		}
		
	}
/*
	printf("ntuser:%s, mx:%s, domain:%s\n",user->nt_user,user->mx_domain,user->nt_domain);
	printf("pdc:%s, addr:%s\n",user->pdc_nbname, user->pdc_hostname);
	printf("bdc:%s, addr:%s\n",user->bdc_nbname, user->bdc_hostname); 
	*/
	(void)(db->close);
    
}

int Valid_MapUser(usercache_data *user)
{
  return(Valid_User(user->nt_user, user->password, user->pdc_nbname, user->bdc_nbname, user->nt_domain));
}
