/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.apiimpl;

import io.smallrye.faulttolerance.api.CircuitBreakerMaintenance;
import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.util.Callbacks;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class BasicCircuitBreakerMaintenanceImpl
implements CircuitBreakerMaintenance {
    private final Set<String> knownNames = ConcurrentHashMap.newKeySet();
    private final ConcurrentMap<String, CircuitBreaker<?>> registry = new ConcurrentHashMap();
    private final ConcurrentMap<String, Collection<Consumer<CircuitBreakerState>>> stateChangeCallbacks = new ConcurrentHashMap<String, Collection<Consumer<CircuitBreakerState>>>();
    private final Predicate<String> circuitBreakerExists;

    public BasicCircuitBreakerMaintenanceImpl() {
        this.circuitBreakerExists = this.knownNames::contains;
    }

    protected BasicCircuitBreakerMaintenanceImpl(Predicate<String> additionalCircuitBreakerExists) {
        this.circuitBreakerExists = name -> additionalCircuitBreakerExists.test((String)name) || this.knownNames.contains(name);
    }

    public void registerName(String circuitBreakerName) {
        this.knownNames.add(circuitBreakerName);
    }

    public void register(String circuitBreakerName, CircuitBreaker<?> circuitBreaker) {
        this.knownNames.add(circuitBreakerName);
        CircuitBreaker<?> previous = this.registry.putIfAbsent(circuitBreakerName, circuitBreaker);
        if (previous != null) {
            throw new IllegalStateException("Circuit breaker already exists: " + circuitBreakerName);
        }
    }

    public CircuitBreakerState currentState(String name) {
        if (!this.circuitBreakerExists.test(name)) {
            throw new IllegalArgumentException("Circuit breaker '" + name + "' doesn't exist");
        }
        CircuitBreaker circuitBreaker = (CircuitBreaker)this.registry.get(name);
        if (circuitBreaker == null) {
            return CircuitBreakerState.CLOSED;
        }
        int currentState = circuitBreaker.currentState();
        switch (currentState) {
            case 0: {
                return CircuitBreakerState.CLOSED;
            }
            case 1: {
                return CircuitBreakerState.OPEN;
            }
            case 2: {
                return CircuitBreakerState.HALF_OPEN;
            }
        }
        throw new IllegalStateException("Unknown circuit breaker state " + currentState);
    }

    public void onStateChange(String name, Consumer<CircuitBreakerState> callback) {
        if (!this.circuitBreakerExists.test(name)) {
            throw new IllegalArgumentException("Circuit breaker '" + name + "' doesn't exist");
        }
        this.stateChangeCallbacks.computeIfAbsent(name, ignored -> new CopyOnWriteArrayList()).add(Callbacks.wrap(callback));
    }

    public Consumer<CircuitBreakerEvents.StateTransition> stateTransitionEventHandler(String name) {
        return stateTransition -> {
            CircuitBreakerState targetState = stateTransition.targetState;
            Collection callbacks = (Collection)this.stateChangeCallbacks.get(name);
            if (callbacks != null) {
                for (Consumer callback : callbacks) {
                    callback.accept(targetState);
                }
            }
        };
    }

    public void reset(String name) {
        if (!this.circuitBreakerExists.test(name)) {
            throw new IllegalArgumentException("Circuit breaker '" + name + "' doesn't exist");
        }
        CircuitBreaker circuitBreaker = (CircuitBreaker)this.registry.get(name);
        if (circuitBreaker != null) {
            circuitBreaker.reset();
        }
    }

    public void resetAll() {
        this.registry.values().forEach(CircuitBreaker::reset);
    }
}

