/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Advice;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.AuthzDecisionStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Statement;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.xmlsec.signature.Signature;

public class AssertionImpl
extends AbstractSignableSAMLObject
implements Assertion {
    @Nullable
    private SAMLVersion version = SAMLVersion.VERSION_20;
    @Nullable
    private Instant issueInstant;
    @Nullable
    private String id;
    @Nullable
    private Issuer issuer;
    @Nullable
    private Subject subject;
    @Nullable
    private Conditions conditions;
    @Nullable
    private Advice advice;
    @Nonnull
    private final IndexedXMLObjectChildrenList<Statement> statements = new IndexedXMLObjectChildrenList((XMLObject)this);

    protected AssertionImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Nullable
    public SAMLVersion getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable SAMLVersion newVersion) {
        this.version = (SAMLVersion)this.prepareForAssignment(this.version, newVersion);
    }

    @Nullable
    public Instant getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(@Nullable Instant newIssueInstance) {
        this.issueInstant = (Instant)this.prepareForAssignment(this.issueInstant, newIssueInstance);
    }

    @Nullable
    public String getID() {
        return this.id;
    }

    public void setID(@Nullable String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    @Nullable
    public Issuer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(@Nullable Issuer newIssuer) {
        this.issuer = (Issuer)this.prepareForAssignment((XMLObject)this.issuer, (XMLObject)newIssuer);
    }

    @Nullable
    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(@Nullable Subject newSubject) {
        this.subject = (Subject)this.prepareForAssignment((XMLObject)this.subject, (XMLObject)newSubject);
    }

    @Nullable
    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(@Nullable Conditions newConditions) {
        this.conditions = (Conditions)this.prepareForAssignment((XMLObject)this.conditions, (XMLObject)newConditions);
    }

    @Nullable
    public Advice getAdvice() {
        return this.advice;
    }

    public void setAdvice(@Nullable Advice newAdvice) {
        this.advice = (Advice)this.prepareForAssignment((XMLObject)this.advice, (XMLObject)newAdvice);
    }

    @Nonnull
    @Live
    public List<Statement> getStatements() {
        return this.statements;
    }

    @Nonnull
    @Live
    public List<Statement> getStatements(@Nonnull QName typeOrName) {
        return this.statements.subList(typeOrName);
    }

    @Nonnull
    @Live
    public List<AuthnStatement> getAuthnStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnStatement", "saml2");
        return this.statements.subList(statementQName);
    }

    @Nonnull
    @Live
    public List<AuthzDecisionStatement> getAuthzDecisionStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthzDecisionStatement", "saml2");
        return this.statements.subList(statementQName);
    }

    @Nonnull
    @Live
    public List<AttributeStatement> getAttributeStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AttributeStatement", "saml2");
        return this.statements.subList(statementQName);
    }

    @Nullable
    public String getSignatureReferenceID() {
        return this.id;
    }

    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        Signature sig;
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.issuer != null) {
            children.add(this.issuer);
        }
        if ((sig = this.getSignature()) != null) {
            children.add(sig);
        }
        if (this.subject != null) {
            children.add(this.subject);
        }
        if (this.conditions != null) {
            children.add(this.conditions);
        }
        if (this.advice != null) {
            children.add(this.advice);
        }
        children.addAll((Collection<Object>)this.statements);
        return CollectionSupport.copyToList(children);
    }
}

