/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.HashSet;
import java.util.Set;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.PersistenceRef;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="persistence-unit-refType", propOrder={"descriptions", "persistenceUnitRefName", "persistenceUnitName", "mappedName", "injectionTarget", "lookupName"})
public class PersistenceUnitRef
implements JndiReference,
PersistenceRef {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(name="persistence-unit-ref-name", required=true)
    protected String persistenceUnitRefName;
    @XmlElement(name="persistence-unit-name")
    protected String persistenceUnitName;
    @XmlElement(name="mapped-name")
    protected String mappedName;
    @XmlElement(name="lookup-name")
    protected String lookupName;
    @XmlElement(name="injection-target", required=true)
    protected Set<InjectionTarget> injectionTarget;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public PersistenceUnitRef() {
    }

    public PersistenceUnitRef(String persistenceUnitRefName, String persistenceUnitName) {
        this.persistenceUnitRefName = persistenceUnitRefName;
        this.persistenceUnitName = persistenceUnitName;
    }

    public PersistenceUnitRef name(String persistenceUnitRefName) {
        this.persistenceUnitRefName = persistenceUnitRefName;
        return this;
    }

    public PersistenceUnitRef unit(String persistenceUnit) {
        this.persistenceUnitName = persistenceUnit;
        return this;
    }

    public PersistenceUnitRef mappedName(String mappedName) {
        this.mappedName = mappedName;
        return this;
    }

    public PersistenceUnitRef lookup(String lookupName) {
        this.lookupName = lookupName;
        return this;
    }

    public PersistenceUnitRef injectionTarget(String className, String property) {
        this.getInjectionTarget().add(new InjectionTarget(className, property));
        if (this.persistenceUnitRefName == null) {
            this.persistenceUnitRefName = "java:comp/env/" + className + "/" + property;
        }
        return this;
    }

    public PersistenceUnitRef injectionTarget(Class<?> clazz, String property) {
        return this.injectionTarget(clazz.getName(), property);
    }

    @Override
    public String getName() {
        return this.getPersistenceUnitRefName();
    }

    @Override
    public String getType() {
        return this.getPersistenceUnitName();
    }

    @Override
    public void setName(String name) {
        this.setPersistenceUnitRefName(name);
    }

    @Override
    public String getKey() {
        String name = this.getName();
        if (name == null || name.startsWith("java:")) {
            return name;
        }
        return "java:comp/env/" + name;
    }

    @Override
    public void setType(String type) {
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public String getPersistenceUnitRefName() {
        return this.persistenceUnitRefName;
    }

    public void setPersistenceUnitRefName(String value) {
        this.persistenceUnitRefName = value;
    }

    @Override
    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    @Override
    public void setPersistenceUnitName(String value) {
        this.persistenceUnitName = value;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public void setMappedName(String value) {
        this.mappedName = value;
    }

    @Override
    public String getLookupName() {
        return this.lookupName;
    }

    @Override
    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    @Override
    public Set<InjectionTarget> getInjectionTarget() {
        if (this.injectionTarget == null) {
            this.injectionTarget = new HashSet<InjectionTarget>();
        }
        return this.injectionTarget;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String toString() {
        return "PersistenceUnitRef{name='" + this.persistenceUnitRefName + "', unit='" + this.persistenceUnitName + "', mappedName='" + this.mappedName + "', lookupName='" + this.lookupName + "'}";
    }
}

