/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.dag.utils.ProtoUtils;

public class DAGKillRequestEvent
implements HistoryEvent,
SummaryEvent {
    private TezDAGID dagID;
    private long killRequestTime;
    private boolean isSessionStopped;

    public DAGKillRequestEvent() {
    }

    public DAGKillRequestEvent(TezDAGID dagID, long killRequestTime, boolean isSessionStopped) {
        this.dagID = dagID;
        this.killRequestTime = killRequestTime;
        this.isSessionStopped = isSessionStopped;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.DAG_KILL_REQUEST;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return false;
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    public RecoveryProtos.DAGKillRequestProto toProto() {
        return RecoveryProtos.DAGKillRequestProto.newBuilder().setDagId(this.dagID.toString()).setKillRequestTime(this.killRequestTime).setIsSessionStopped(this.isSessionStopped).build();
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.DAGKillRequestProto proto = (RecoveryProtos.DAGKillRequestProto)inputStream.readMessage(RecoveryProtos.DAGKillRequestProto.PARSER, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public void fromProto(RecoveryProtos.DAGKillRequestProto proto) {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.killRequestTime = proto.getKillRequestTime();
        this.isSessionStopped = proto.getIsSessionStopped();
    }

    @Override
    public void toSummaryProtoStream(OutputStream outputStream) throws IOException {
        byte[] byArray;
        if (this.isSessionStopped) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        ProtoUtils.toSummaryEventProto(this.dagID, this.killRequestTime, HistoryEventType.DAG_KILL_REQUEST, byArray).writeDelimitedTo(outputStream);
    }

    @Override
    public void fromSummaryProtoStream(RecoveryProtos.SummaryEventProto proto) throws IOException {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.killRequestTime = proto.getTimestamp();
        this.isSessionStopped = proto.getEventPayload().byteAt(0) == 1;
    }

    @Override
    public boolean writeToRecoveryImmediately() {
        return false;
    }

    public TezDAGID getDagID() {
        return this.dagID;
    }

    public long getKillRequestTime() {
        return this.killRequestTime;
    }

    public boolean isSessionStopped() {
        return this.isSessionStopped;
    }
}

