/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.core.provisioning.api.pushpull.LiveSyncDeltaMapper;
import org.apache.syncope.core.provisioning.java.pushpull.SyncReplInboundActions;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.LiveSyncDelta;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;

public class SyncReplLiveSyncDeltaMapper
implements LiveSyncDeltaMapper {
    protected static final Set<String> FILTERING_ATTRS = Set.of(Uid.NAME, Name.NAME, SyncReplInboundActions.SYNCREPL_COOKIE_NAME);

    protected SyncDelta doMap(LiveSyncDelta liveSyncDelta) {
        String cookie = Optional.ofNullable(liveSyncDelta.getObject().getAttributeByName(SyncReplInboundActions.SYNCREPL_COOKIE_NAME)).map(AttributeUtil::getStringValue).filter(Objects::nonNull).orElseThrow(() -> new IllegalArgumentException("Could not find the " + SyncReplInboundActions.SYNCREPL_COOKIE_NAME + " attribute"));
        SyncDeltaType syncDeltaType = liveSyncDelta.getUid().getUidValue().equals(liveSyncDelta.getObject().getName().getNameValue()) ? SyncDeltaType.DELETE : SyncDeltaType.CREATE_OR_UPDATE;
        ConnectorObjectBuilder connObjectBuilder = new ConnectorObjectBuilder().setObjectClass(liveSyncDelta.getObjectClass()).setUid(liveSyncDelta.getUid()).setName(liveSyncDelta.getObject().getName());
        liveSyncDelta.getObject().getAttributes().stream().filter(attr -> !FILTERING_ATTRS.contains(attr.getName())).forEach(xva$0 -> connObjectBuilder.addAttribute(new Attribute[]{xva$0}));
        return new SyncDeltaBuilder().setToken(new SyncToken((Object)cookie)).setDeltaType(syncDeltaType).setObject(connObjectBuilder.build()).build();
    }

    public SyncDelta map(LiveSyncDelta liveSyncDelta, OrgUnit orgUnit) {
        if (!orgUnit.getObjectClass().equals(liveSyncDelta.getObjectClass().getObjectClassValue())) {
            throw new IllegalArgumentException("Expected " + orgUnit.getObjectClass() + ", got " + liveSyncDelta.getObjectClass().getObjectClassValue());
        }
        return this.doMap(liveSyncDelta);
    }

    public SyncDelta map(LiveSyncDelta liveSyncDelta, Provision provision) {
        if (!provision.getObjectClass().equals(liveSyncDelta.getObjectClass().getObjectClassValue())) {
            throw new IllegalArgumentException("Expected " + provision.getObjectClass() + ", got " + liveSyncDelta.getObjectClass().getObjectClassValue());
        }
        return this.doMap(liveSyncDelta);
    }
}

