/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.web.client;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.OnlyOnceLoggingDenyMeterFilter;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationProperties;
import org.springframework.boot.actuate.autoconfigure.observation.web.client.RestClientObservationConfiguration;
import org.springframework.boot.actuate.autoconfigure.observation.web.client.RestTemplateObservationConfiguration;
import org.springframework.boot.actuate.autoconfigure.observation.web.client.WebClientObservationConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;

@AutoConfiguration(after={ObservationAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, RestTemplateAutoConfiguration.class, WebClientAutoConfiguration.class, RestClientAutoConfiguration.class})
@ConditionalOnClass(value={Observation.class})
@ConditionalOnBean(value={ObservationRegistry.class})
@Import(value={RestTemplateObservationConfiguration.class, WebClientObservationConfiguration.class, RestClientObservationConfiguration.class})
@EnableConfigurationProperties(value={MetricsProperties.class, ObservationProperties.class})
public class HttpClientObservationsAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MeterRegistry.class})
    @ConditionalOnBean(value={MeterRegistry.class})
    static class MeterFilterConfiguration {
        MeterFilterConfiguration() {
        }

        @Bean
        @Order(value=0)
        OnlyOnceLoggingDenyMeterFilter metricsHttpClientUriTagFilter(ObservationProperties observationProperties, MetricsProperties metricsProperties) {
            MetricsProperties.Web.Client clientProperties = metricsProperties.getWeb().getClient();
            String meterNamePrefix = observationProperties.getHttp().getClient().getRequests().getName();
            int maxUriTags = clientProperties.getMaxUriTags();
            return new OnlyOnceLoggingDenyMeterFilter(meterNamePrefix, "uri", maxUriTags, "Are you using 'uriVariables'?");
        }
    }
}

