/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test.profiler;

import java.util.Map;
import org.flowable.engine.test.profiler.CommandStats;
import org.flowable.engine.test.profiler.FlowableProfiler;
import org.flowable.engine.test.profiler.ProfileSession;

public class ConsoleLogger {
    protected FlowableProfiler profiler;

    public ConsoleLogger(FlowableProfiler profiler) {
        this.profiler = profiler;
    }

    public void log() {
        for (ProfileSession profileSession : this.profiler.getProfileSessions()) {
            System.out.println();
            System.out.println("#############################################");
            System.out.println("#############################################");
            System.out.println(profileSession.getName());
            System.out.println("#############################################");
            System.out.println("#############################################");
            System.out.println();
            System.out.println("Start time: " + String.valueOf(profileSession.getStartTime()));
            System.out.println("End time: " + String.valueOf(profileSession.getEndTime()));
            System.out.println("Total time: " + profileSession.getTotalTime() + " ms");
            System.out.println();
            Map<String, CommandStats> allStats = profileSession.calculateSummaryStatistics();
            for (String classFqn : allStats.keySet()) {
                CommandStats stats = allStats.get(classFqn);
                System.out.println("Command class: " + classFqn);
                System.out.println("Number of times invoked: " + stats.getCount());
                double commandPercentage = (double)stats.getTotalCommandTime / (double)profileSession.getTotalTime();
                System.out.println(100.0 * (double)Math.round(commandPercentage * 100.0) / 100.0 + "% of profile session was spent executing this command");
                System.out.println();
                System.out.println("Average execution time: " + stats.getAverageExecutionTime() + " ms (Average database time: " + stats.getAverageDatabaseExecutionTime() + " ms (" + stats.getAverageDatabaseExecutionTimePercentage() + "%) )");
                System.out.println();
                System.out.println("Database selects:");
                for (String select : stats.getDbSelects().keySet()) {
                    System.out.println(select + " : " + String.valueOf(stats.getDbSelects().get(select)));
                }
                System.out.println();
                System.out.println("Database inserts:");
                for (String insert : stats.getDbInserts().keySet()) {
                    System.out.println(insert + " : " + String.valueOf(stats.getDbInserts().get(insert)));
                }
                System.out.println();
                System.out.println("Database updates:");
                for (String update : stats.getDbUpdates().keySet()) {
                    System.out.println(update + " : " + String.valueOf(stats.getDbSelects().get(update)));
                }
                System.out.println();
                System.out.println("Database delete:");
                for (String delete : stats.getDbDeletes().keySet()) {
                    System.out.println(delete + " : " + String.valueOf(stats.getDbDeletes().get(delete)));
                }
                System.out.println();
                System.out.println();
            }
        }
    }
}

