/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid.impl;

import com.fasterxml.uuid.NoArgGenerator;
import com.fasterxml.uuid.UUIDClock;
import com.fasterxml.uuid.UUIDType;
import com.fasterxml.uuid.impl.LazyRandom;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;

public class TimeBasedEpochGenerator
extends NoArgGenerator {
    private static final int ENTROPY_BYTE_LENGTH = 10;
    protected final Consumer<byte[]> _randomNextBytes;
    protected final UUIDClock _clock;
    private long _lastTimestamp = -1L;
    private final byte[] _lastEntropy = new byte[10];

    public TimeBasedEpochGenerator(Random rnd) {
        this(rnd, UUIDClock.systemTimeClock());
    }

    public TimeBasedEpochGenerator(Random rnd, UUIDClock clock) {
        this((rnd == null ? LazyRandom.sharedSecureRandom() : rnd)::nextBytes, clock);
    }

    protected TimeBasedEpochGenerator(Consumer<byte[]> randomNextBytes, UUIDClock clock) {
        this._randomNextBytes = Objects.requireNonNull(randomNextBytes);
        this._clock = clock;
    }

    @Override
    public UUIDType getType() {
        return UUIDType.TIME_BASED_EPOCH;
    }

    @Override
    public UUID generate() {
        return this.construct(this._clock.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID construct(long rawTimestamp) {
        byte[] byArray = this._lastEntropy;
        synchronized (this._lastEntropy) {
            block8: {
                if (rawTimestamp == this._lastTimestamp) {
                    for (int i = 9; i > 0; --i) {
                        this._lastEntropy[i] = (byte)(this._lastEntropy[i] + 1);
                        if (this._lastEntropy[i] == 0) {
                            continue;
                        }
                        break block8;
                    }
                    this._lastEntropy[0] = (byte)(this._lastEntropy[0] + 1);
                    if (this._lastEntropy[0] >= 4) {
                        throw new IllegalStateException("overflow on same millisecond");
                    }
                } else {
                    this._lastTimestamp = rawTimestamp;
                    this._randomNextBytes.accept(this._lastEntropy);
                    this._lastEntropy[0] = (byte)(this._lastEntropy[0] & 1);
                }
            }
            long mostSigBits = rawTimestamp << 16 | (long)UUIDType.TIME_BASED_EPOCH.raw() << 12 | Byte.toUnsignedLong(this._lastEntropy[0]) << 10 | Byte.toUnsignedLong(this._lastEntropy[1]) << 2 | Byte.toUnsignedLong(this._lastEntropy[2]) >>> 6;
            long right62Mask = 0x3FFFFFFFFFFFFFFFL;
            long variant = 2L;
            long leastSigBits = variant << 62 | TimeBasedEpochGenerator._toLong(this._lastEntropy, 2) & right62Mask;
            // ** MonitorExit[var7_2] (shouldn't be in output)
            return new UUID(mostSigBits, leastSigBits);
        }
    }
}

