/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.upgrade;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class WebFlowUpgrader {
    private static final String XSL_NAME = "spring-webflow-1.0-to-2.0.xsl";
    private Transformer transformer;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("The file path to the flow to convert is required");
            System.exit(-1);
        }
        WebFlowUpgrader converter = new WebFlowUpgrader();
        String result = converter.convert((Resource)new FileSystemResource(args[0]));
        System.out.println(result);
    }

    public String convert(Resource flowResource) {
        StringWriter output = new StringWriter();
        try {
            StreamSource source = new StreamSource(flowResource.getInputStream());
            StreamResult result = new StreamResult(output);
            this.transform(source, result);
        }
        catch (IOException | TransformerException e) {
            e.printStackTrace();
        }
        return output.toString();
    }

    public synchronized void transform(Source source, Result result) throws TransformerConfigurationException, TransformerException, IOException {
        this.getTransformer().transform(source, result);
    }

    private Transformer getTransformer() throws TransformerConfigurationException, IOException {
        if (this.transformer == null) {
            ClassPathResource xslResource = new ClassPathResource(XSL_NAME, this.getClass());
            TransformerFactory factory = TransformerFactory.newInstance();
            StreamSource source = new StreamSource(xslResource.getInputStream());
            this.transformer = factory.newTransformer(source);
            this.transformer.setOutputProperty("{https://xml.apache.org/xalan}indent-amount", "4");
        }
        return this.transformer;
    }
}

