/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.profile;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPIssuer;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPProtectedResourceRequestVerifier;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.DPoPAccessToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20UserProfileEndpointController;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public class OidcUserProfileEndpointController
extends OAuth20UserProfileEndpointController<OidcConfigurationContext> {
    public OidcUserProfileEndpointController(OidcConfigurationContext configurationContext) {
        super((OAuth20ConfigurationContext)configurationContext);
    }

    @GetMapping(value={"/oidc/profile", "/**/oidcProfile"}, produces={"application/json", "application/jwt"})
    public ResponseEntity handleGetRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, "oidcProfile")) {
            Map body = OAuth20Utils.getErrorResponseBody((String)"invalid_request", (String)"Invalid issuer");
            return new ResponseEntity((Object)body, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        return super.handleGetRequest(request, response);
    }

    @PostMapping(value={"/oidc/profile", "/**/oidcProfile"}, produces={"application/json", "application/jwt"})
    public ResponseEntity<String> handlePostRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.handleGetRequest(request, response);
    }

    protected void validateAccessToken(String accessTokenId, OAuth20AccessToken accessToken, HttpServletRequest request, HttpServletResponse response) {
        String dPopProof = request.getHeader("DPoP");
        if (accessToken.getAuthentication().containsAttribute("DPoPConfirmation")) {
            Optional cnf = CollectionUtils.firstElement(accessToken.getAuthentication().getAttributes().get("DPoPConfirmation"));
            cnf.ifPresent(Unchecked.consumer(conf -> {
                JWKThumbprintConfirmation confirmation = new JWKThumbprintConfirmation(new Base64URL(conf.toString()));
                Set acceptedAlgs = ((OidcConfigurationContext)this.getConfigurationContext()).getDiscoverySettings().getDPopSigningAlgValuesSupported().stream().map(JWSAlgorithm::parse).collect(Collectors.toSet());
                long seconds = Beans.newDuration((String)((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc().getCore().getSkew()).toSeconds();
                DPoPProtectedResourceRequestVerifier verifier = new DPoPProtectedResourceRequestVerifier(acceptedAlgs, seconds, null);
                SignedJWT signedProof = SignedJWT.parse((String)dPopProof);
                DPoPIssuer dPoPIssuer = new DPoPIssuer(new ClientID(accessToken.getClientId()));
                Assert.notNull((Object)JWTParser.parse((String)accessTokenId), (String)"Provided access token id must be a (signed) JWT");
                DPoPAccessToken dpopAccessToken = new DPoPAccessToken(accessTokenId);
                verifier.verify(request.getMethod(), new URI(request.getRequestURL().toString()), dPoPIssuer, signedProof, dpopAccessToken, confirmation);
            }));
        }
    }
}

