/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.http.authc;

import com.okta.commons.http.Request;
import com.okta.commons.http.authc.RequestAuthenticationException;
import com.okta.commons.http.authc.RequestAuthenticator;
import com.okta.commons.lang.Assert;
import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.impl.oauth2.OAuth2AccessToken;
import com.okta.sdk.impl.oauth2.OAuth2ClientCredentials;
import com.okta.sdk.impl.oauth2.OAuth2TokenRetrieverException;
import java.io.IOException;
import java.security.InvalidKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2RequestAuthenticator
implements RequestAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(OAuth2RequestAuthenticator.class);
    private final ClientCredentials<OAuth2AccessToken> clientCredentials;

    public OAuth2RequestAuthenticator(ClientCredentials<OAuth2AccessToken> clientCredentials) {
        Assert.notNull(clientCredentials, (String)"clientCredentials may not be null");
        this.clientCredentials = clientCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(Request request) throws RequestAuthenticationException {
        OAuth2AccessToken oAuth2AccessToken = (OAuth2AccessToken)this.clientCredentials.getCredentials();
        if (oAuth2AccessToken.hasExpired()) {
            log.debug("OAuth2 access token expiry detected. Will fetch a new token from Authorization server");
            OAuth2RequestAuthenticator oAuth2RequestAuthenticator = this;
            synchronized (oAuth2RequestAuthenticator) {
                if (oAuth2AccessToken.hasExpired()) {
                    try {
                        OAuth2ClientCredentials oAuth2ClientCredentials = (OAuth2ClientCredentials)this.clientCredentials;
                        oAuth2AccessToken = oAuth2ClientCredentials.getAccessTokenRetrieverService().getOAuth2AccessToken();
                        oAuth2ClientCredentials.setCredentials(oAuth2AccessToken);
                    }
                    catch (IOException | InvalidKeyException e) {
                        throw new OAuth2TokenRetrieverException("Failed to renew expired OAuth2 access token", e);
                    }
                }
            }
        }
        request.getHeaders().set("Authorization", "Bearer " + oAuth2AccessToken.getAccessToken());
    }
}

