/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.authenticator;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.security.auth.x500.X500Principal;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.http.credentials.X509Credentials;
import org.pac4j.http.credentials.authenticator.AbstractRegexpAuthenticator;
import org.pac4j.http.profile.X509Profile;

public class X509Authenticator
extends AbstractRegexpAuthenticator
implements Authenticator {
    public X509Authenticator() {
        this.setRegexpPattern("CN=(.*?)(?:,|$)");
    }

    public X509Authenticator(String regexpPattern) {
        this.setRegexpPattern(regexpPattern);
    }

    protected void internalInit(boolean forceReinit) {
        this.setProfileDefinitionIfUndefined((ProfileDefinition)new CommonProfileDefinition(x -> new X509Profile()));
    }

    public Optional<Credentials> validate(CallContext ctx, Credentials credentials) {
        X500Principal issuerX500Principal;
        this.init();
        X509Certificate certificate = ((X509Credentials)credentials).getCertificate();
        if (certificate == null) {
            throw new CredentialsException("No X509 certificate");
        }
        Principal principal = certificate.getSubjectDN();
        if (principal == null) {
            throw new CredentialsException("No X509 principal");
        }
        String subjectDN = principal.getName();
        this.logger.debug("subjectDN: {}", (Object)subjectDN);
        if (subjectDN == null) {
            throw new CredentialsException("No X509 subjectDN");
        }
        Matcher matcher = this.pattern.matcher(subjectDN);
        if (!matcher.find()) {
            throw new CredentialsException("No matching for pattern: " + this.regexpPattern + " in subjectDN: " + subjectDN);
        }
        if (matcher.groupCount() != 1) {
            throw new CredentialsException("Too many matches for pattern: " + this.regexpPattern + " in subjectDN: " + subjectDN);
        }
        String id = matcher.group(1);
        UserProfile profile = this.getProfileDefinition().newProfile(new Object[0]);
        profile.setId(id);
        try {
            profile.addAttribute("x509-certificate", (Object)Base64.getEncoder().encodeToString(certificate.getEncoded()));
        }
        catch (Exception e) {
            throw new CredentialsException("Unable to encode the certificate", (Throwable)e);
        }
        profile.addAttribute("x509-subjectDN", (Object)subjectDN);
        profile.addAttribute("x509-notAfter", (Object)certificate.getNotAfter());
        profile.addAttribute("x509-notBefore", (Object)certificate.getNotBefore());
        profile.addAttribute("x509-sigAlgName", (Object)certificate.getSigAlgName());
        profile.addAttribute("x509-sigAlgOid", (Object)certificate.getSigAlgOID());
        this.extractExtensionFromCertificate(profile, certificate, "x509-sanEmail", 1);
        this.extractExtensionFromCertificate(profile, certificate, "x509-sanDNS", 2);
        this.extractExtensionFromCertificate(profile, certificate, "x509-sanURI", 6);
        this.extractExtensionFromCertificate(profile, certificate, "x509-sanIP", 7);
        this.extractExtensionFromCertificate(profile, certificate, "x509-sanRegisteredID", 8);
        this.extractExtensionFromCertificate(profile, certificate, "x509-sanDirectory", 9);
        Principal issuerDN = certificate.getIssuerDN();
        if (issuerDN != null) {
            profile.addAttribute("x509-issuer", (Object)issuerDN.getName());
        }
        if ((issuerX500Principal = certificate.getIssuerX500Principal()) != null) {
            profile.addAttribute("x509-issuerX500", (Object)issuerX500Principal.getName());
        }
        this.logger.debug("profile: {}", (Object)profile);
        credentials.setUserProfile(profile);
        return Optional.of(credentials);
    }

    protected void extractExtensionFromCertificate(UserProfile profile, X509Certificate certificate, String attribute, int oid) {
        try {
            List<String> values;
            Collection<List<?>> subjectAlternativeNames = certificate.getSubjectAlternativeNames();
            if (subjectAlternativeNames != null && !(values = subjectAlternativeNames.stream().filter(entry -> entry.size() == 2).filter(entry -> entry.get(0).equals(oid)).map(entry -> entry.get(1).toString()).toList()).isEmpty()) {
                profile.addAttribute(attribute, values);
            }
        }
        catch (Exception e) {
            this.logger.debug("Unable to extract extension", (Throwable)e);
        }
    }
}

