/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.transformations;

import com.unboundid.ldap.matchingrules.DistinguishedNameMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.transformations.EntryTransformation;
import com.unboundid.ldap.sdk.transformations.LDIFChangeRecordTransformation;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RenameAttributeTransformation
implements EntryTransformation,
LDIFChangeRecordTransformation {
    private final boolean renameInDNs;
    @Nullable
    private final Schema schema;
    @NotNull
    private final Set<String> baseSourceNames;
    @NotNull
    private final String baseTargetName;

    public RenameAttributeTransformation(@Nullable Schema schema, @NotNull String sourceAttribute, @NotNull String targetAttribute, boolean renameInDNs) {
        AttributeTypeDefinition at;
        this.renameInDNs = renameInDNs;
        Schema s = schema;
        if (s == null) {
            try {
                s = Schema.getDefaultStandardSchema();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.schema = s;
        HashSet<String> sourceNames = new HashSet<String>(StaticUtils.computeMapCapacity(5));
        String baseSourceName = StaticUtils.toLowerCase(Attribute.getBaseName(sourceAttribute));
        sourceNames.add(baseSourceName);
        if (s != null && (at = s.getAttributeType(baseSourceName)) != null) {
            sourceNames.add(StaticUtils.toLowerCase(at.getOID()));
            for (String name : at.getNames()) {
                sourceNames.add(StaticUtils.toLowerCase(name));
            }
        }
        this.baseSourceNames = Collections.unmodifiableSet(sourceNames);
        this.baseTargetName = Attribute.getBaseName(targetAttribute);
    }

    @Override
    @Nullable
    public Entry transformEntry(@NotNull Entry e) {
        if (e == null) {
            return null;
        }
        String newDN = this.renameInDNs ? this.replaceDN(e.getDN()) : e.getDN();
        Collection<Attribute> originalAttributes = e.getAttributes();
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>(originalAttributes.size());
        for (Attribute a : originalAttributes) {
            String[] newValues;
            String newName;
            String baseName = StaticUtils.toLowerCase(a.getBaseName());
            if (this.baseSourceNames.contains(baseName)) {
                if (a.hasOptions()) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(this.baseTargetName);
                    for (String option : a.getOptions()) {
                        buffer.append(';');
                        buffer.append(option);
                    }
                    newName = buffer.toString();
                } else {
                    newName = this.baseTargetName;
                }
            } else {
                newName = a.getName();
            }
            if (this.renameInDNs && this.schema != null && MatchingRule.selectEqualityMatchingRule(baseName, this.schema) instanceof DistinguishedNameMatchingRule) {
                String[] originalValues = a.getValues();
                newValues = new String[originalValues.length];
                for (int i = 0; i < originalValues.length; ++i) {
                    newValues[i] = this.replaceDN(originalValues[i]);
                }
            } else {
                newValues = a.getValues();
            }
            newAttributes.add(new Attribute(newName, this.schema, newValues));
        }
        return new Entry(newDN, newAttributes);
    }

    @Override
    @Nullable
    public LDIFChangeRecord transformChangeRecord(@NotNull LDIFChangeRecord r) {
        if (r == null) {
            return null;
        }
        if (r instanceof LDIFAddChangeRecord) {
            LDIFAddChangeRecord addRecord = (LDIFAddChangeRecord)r;
            return new LDIFAddChangeRecord(this.transformEntry(addRecord.getEntryToAdd()), addRecord.getControls());
        }
        if (r instanceof LDIFDeleteChangeRecord) {
            if (this.renameInDNs) {
                return new LDIFDeleteChangeRecord(this.replaceDN(r.getDN()), r.getControls());
            }
            return r;
        }
        if (r instanceof LDIFModifyChangeRecord) {
            LDIFModifyChangeRecord modRecord = (LDIFModifyChangeRecord)r;
            String newDN = this.renameInDNs ? this.replaceDN(modRecord.getDN()) : modRecord.getDN();
            Modification[] originalMods = modRecord.getModifications();
            Modification[] newMods = new Modification[originalMods.length];
            for (int i = 0; i < originalMods.length; ++i) {
                String[] newValues;
                String newName;
                Modification m = originalMods[i];
                String baseName = StaticUtils.toLowerCase(Attribute.getBaseName(m.getAttributeName()));
                if (this.baseSourceNames.contains(baseName)) {
                    Set<String> options = Attribute.getOptions(m.getAttributeName());
                    if (options.isEmpty()) {
                        newName = this.baseTargetName;
                    } else {
                        StringBuilder buffer = new StringBuilder();
                        buffer.append(this.baseTargetName);
                        for (String option : options) {
                            buffer.append(';');
                            buffer.append(option);
                        }
                        newName = buffer.toString();
                    }
                } else {
                    newName = m.getAttributeName();
                }
                if (this.renameInDNs && this.schema != null && MatchingRule.selectEqualityMatchingRule(baseName, this.schema) instanceof DistinguishedNameMatchingRule) {
                    String[] originalValues = m.getValues();
                    newValues = new String[originalValues.length];
                    for (int j = 0; j < originalValues.length; ++j) {
                        newValues[j] = this.replaceDN(originalValues[j]);
                    }
                } else {
                    newValues = m.getValues();
                }
                newMods[i] = new Modification(m.getModificationType(), newName, newValues);
            }
            return new LDIFModifyChangeRecord(newDN, newMods, modRecord.getControls());
        }
        if (r instanceof LDIFModifyDNChangeRecord) {
            if (this.renameInDNs) {
                LDIFModifyDNChangeRecord modDNRecord = (LDIFModifyDNChangeRecord)r;
                return new LDIFModifyDNChangeRecord(this.replaceDN(modDNRecord.getDN()), this.replaceDN(modDNRecord.getNewRDN()), modDNRecord.deleteOldRDN(), this.replaceDN(modDNRecord.getNewSuperiorDN()), modDNRecord.getControls());
            }
            return r;
        }
        return r;
    }

    @NotNull
    private String replaceDN(@NotNull String dn) {
        try {
            DN parsedDN = new DN(dn);
            RDN[] originalRDNs = parsedDN.getRDNs();
            RDN[] newRDNs = new RDN[originalRDNs.length];
            for (int i = 0; i < originalRDNs.length; ++i) {
                String[] originalNames = originalRDNs[i].getAttributeNames();
                String[] newNames = new String[originalNames.length];
                for (int j = 0; j < originalNames.length; ++j) {
                    newNames[j] = this.baseSourceNames.contains(StaticUtils.toLowerCase(originalNames[j])) ? this.baseTargetName : originalNames[j];
                }
                newRDNs[i] = new RDN(newNames, originalRDNs[i].getByteArrayAttributeValues());
            }
            return new DN(newRDNs).toString();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return dn;
        }
    }

    @Override
    @Nullable
    public Entry translate(@NotNull Entry original, long firstLineNumber) {
        return this.transformEntry(original);
    }

    @Override
    @Nullable
    public LDIFChangeRecord translate(@NotNull LDIFChangeRecord original, long firstLineNumber) {
        return this.transformChangeRecord(original);
    }

    @Override
    @Nullable
    public Entry translateEntryToWrite(@NotNull Entry original) {
        return this.transformEntry(original);
    }

    @Override
    @Nullable
    public LDIFChangeRecord translateChangeRecordToWrite(@NotNull LDIFChangeRecord original) {
        return this.transformChangeRecord(original);
    }
}

