/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty;

import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;

public class ChannelBindException
extends RuntimeException {
    final String localHost;
    final int localPort;
    private static final long serialVersionUID = 1718814250958680216L;

    public static ChannelBindException fail(SocketAddress bindAddress, @Nullable Throwable cause) {
        Objects.requireNonNull(bindAddress, "bindAddress");
        if (cause instanceof BindException || cause instanceof IOException && cause.getMessage() != null && cause.getMessage().contains("bind(..)")) {
            cause = null;
        }
        if (!(bindAddress instanceof InetSocketAddress)) {
            return new ChannelBindException(bindAddress.toString(), cause);
        }
        InetSocketAddress address = (InetSocketAddress)bindAddress;
        return new ChannelBindException(address.getHostString(), address.getPort(), cause);
    }

    protected ChannelBindException(String localHost, int localPort, @Nullable Throwable cause) {
        super("Failed to bind on [" + localHost + ":" + localPort + "]", cause);
        this.localHost = localHost;
        this.localPort = localPort;
    }

    protected ChannelBindException(String localHost, @Nullable Throwable cause) {
        super("Failed to bind on [" + localHost + "]", cause);
        this.localHost = localHost;
        this.localPort = -1;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public String localHost() {
        return this.localHost;
    }

    public int localPort() {
        return this.localPort;
    }
}

