/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.resultset.connective;

import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.common.QueryCostComparators;
import com.googlecode.cqengine.resultset.common.ResultSets;
import com.googlecode.cqengine.resultset.filter.FilteringIterator;
import com.googlecode.cqengine.resultset.iterator.IteratorUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ResultSetIntersection<O>
extends ResultSet<O> {
    final Query<O> query;
    final List<ResultSet<O>> resultSets;
    final QueryOptions queryOptions;
    final boolean useIndexMergeStrategy;

    public ResultSetIntersection(Iterable<ResultSet<O>> resultSets, Query<O> query, QueryOptions queryOptions, boolean useIndexMergeStrategy) {
        this.query = query;
        this.queryOptions = queryOptions;
        List<ResultSet<O>> sortedResultSets = ResultSets.wrapWithCostCachingIfNecessary(resultSets);
        Collections.sort(sortedResultSets, QueryCostComparators.getMergeCostComparator());
        this.resultSets = sortedResultSets;
        this.useIndexMergeStrategy = useIndexMergeStrategy;
    }

    @Override
    public Iterator<O> iterator() {
        if (this.resultSets.isEmpty()) {
            return Collections.emptySet().iterator();
        }
        if (this.resultSets.size() == 1) {
            return this.resultSets.get(0).iterator();
        }
        ResultSet<O> lowestMergeCostResultSet = this.resultSets.get(0);
        final List<ResultSet<O>> moreExpensiveResultSets = this.resultSets.subList(1, this.resultSets.size());
        if (this.useIndexMergeStrategy) {
            return new FilteringIterator<O>(lowestMergeCostResultSet.iterator(), this.queryOptions){

                @Override
                public boolean isValid(O object, QueryOptions queryOptions) {
                    for (ResultSet resultSet : moreExpensiveResultSets) {
                        if (resultSet.contains(object)) continue;
                        return false;
                    }
                    return true;
                }
            };
        }
        return new FilteringIterator<O>(lowestMergeCostResultSet.iterator(), this.queryOptions){

            @Override
            public boolean isValid(O object, QueryOptions queryOptions) {
                for (ResultSet resultSet : moreExpensiveResultSets) {
                    if (resultSet.matches(object)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public boolean contains(O object) {
        if (this.resultSets.isEmpty()) {
            return false;
        }
        for (ResultSet<O> resultSet : this.resultSets) {
            if (resultSet.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(O object) {
        return this.query.matches(object, this.queryOptions);
    }

    @Override
    public int size() {
        return IteratorUtil.countElements(this);
    }

    @Override
    public int getRetrievalCost() {
        if (this.resultSets.isEmpty()) {
            return 0;
        }
        ResultSet<O> lowestMergeCostResultSet = this.resultSets.get(0);
        return lowestMergeCostResultSet.getRetrievalCost();
    }

    @Override
    public int getMergeCost() {
        if (this.resultSets.isEmpty()) {
            return 0;
        }
        ResultSet<O> lowestMergeCostResultSet = this.resultSets.get(0);
        return lowestMergeCostResultSet.getMergeCost();
    }

    @Override
    public void close() {
        for (ResultSet<O> resultSet : this.resultSets) {
            resultSet.close();
        }
    }

    @Override
    public Query<O> getQuery() {
        return this.query;
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }
}

