/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.validation.json;

import java.util.List;
import java.util.Map;
import org.apereo.cas.client.authentication.AttributePrincipalImpl;
import org.apereo.cas.client.proxy.ProxyGrantingTicketStorage;
import org.apereo.cas.client.proxy.ProxyRetriever;
import org.apereo.cas.client.util.CommonUtils;
import org.apereo.cas.client.validation.Assertion;
import org.apereo.cas.client.validation.AssertionImpl;

record TicketValidationJsonResponse(CasServiceResponseAuthentication serviceResponse) {
    Assertion getAssertion(ProxyGrantingTicketStorage proxyGrantingTicketStorage, ProxyRetriever proxyRetriever) {
        AssertionImpl assertion;
        String proxyGrantingTicketIou = this.serviceResponse().authenticationSuccess().getProxyGrantingTicket();
        String proxyGrantingTicket = CommonUtils.isBlank(proxyGrantingTicketIou) || proxyGrantingTicketStorage == null ? null : proxyGrantingTicketStorage.retrieve(proxyGrantingTicketIou);
        Map attributes = this.serviceResponse().authenticationSuccess().getAttributes();
        String principal = this.serviceResponse().authenticationSuccess().getUser();
        if (CommonUtils.isNotBlank(proxyGrantingTicket)) {
            AttributePrincipalImpl attributePrincipal = new AttributePrincipalImpl(principal, attributes, proxyGrantingTicket, proxyRetriever);
            assertion = new AssertionImpl(attributePrincipal);
        } else {
            assertion = new AssertionImpl(new AttributePrincipalImpl(principal, attributes));
        }
        return assertion;
    }

    record CasServiceResponseAuthentication(CasServiceResponseAuthenticationFailure authenticationFailure, CasServiceResponseAuthenticationSuccess authenticationSuccess) {
    }

    static class CasServiceResponseAuthenticationSuccess {
        private String user;
        private String proxyGrantingTicket;
        private List proxies;
        private Map attributes;

        CasServiceResponseAuthenticationSuccess() {
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getProxyGrantingTicket() {
            return this.proxyGrantingTicket;
        }

        public void setProxyGrantingTicket(String proxyGrantingTicket) {
            this.proxyGrantingTicket = proxyGrantingTicket;
        }

        public List getProxies() {
            return this.proxies;
        }

        public void setProxies(List proxies) {
            this.proxies = proxies;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map attributes) {
            this.attributes = attributes;
        }
    }

    static class CasServiceResponseAuthenticationFailure {
        private String code;
        private String description;

        CasServiceResponseAuthenticationFailure() {
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

