/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class OAuth20RevocationEndpointController<T extends OAuth20ConfigurationContext>
extends BaseOAuth20Controller<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20RevocationEndpointController.class);

    public OAuth20RevocationEndpointController(T oAuthConfigurationContext) {
        super(oAuthConfigurationContext);
    }

    @PostMapping(path={"/oauth2.0/revoke"}, produces={"application/json"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        JEEContext context = new JEEContext(request, response);
        if (!this.verifyRevocationRequest((WebContext)context)) {
            LOGGER.error("Revocation request verification failed. Request is missing required parameters");
            return OAuth20Utils.writeError(response, "invalid_request");
        }
        ProfileManager manager = new ProfileManager((WebContext)context, ((OAuth20ConfigurationContext)this.getConfigurationContext()).getSessionStore());
        CallContext callContext = new CallContext((WebContext)context, ((OAuth20ConfigurationContext)this.getConfigurationContext()).getSessionStore());
        String clientId = (String)((OAuth20ConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver().resolveClientIdAndClientSecret(callContext).getLeft();
        OAuthRegisteredService registeredService = this.getRegisteredServiceByClientId(clientId);
        if (OAuth20Utils.doesServiceNeedAuthentication(registeredService)) {
            if (manager.getProfile().isEmpty()) {
                LOGGER.warn("Service [{}] requests authentication", (Object)clientId);
                return OAuth20Utils.writeError(response, "access_denied");
            }
        } else {
            WebApplicationService service = (WebApplicationService)((OAuth20ConfigurationContext)this.getConfigurationContext()).getWebApplicationServiceServiceFactory().createService(registeredService.getServiceId());
            AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).build();
            AuditableExecutionResult accessResult = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getRegisteredServiceAccessStrategyEnforcer().execute(audit);
            if (accessResult.isExecutionFailure()) {
                return OAuth20Utils.writeError(response, "invalid_request");
            }
        }
        String token = context.getRequestParameter("token").map(String::valueOf).orElse("");
        return this.generateRevocationResponse(token, clientId, response);
    }

    protected ModelAndView generateRevocationResponse(String token, String clientId, HttpServletResponse response) throws Exception {
        OAuth20Token registryToken = (OAuth20Token)FunctionUtils.doAndHandle(() -> {
            OAuth20Token state = (OAuth20Token)((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry().getTicket(token, OAuth20Token.class);
            return state == null || state.isExpired() ? null : state;
        });
        if (registryToken == null) {
            LOGGER.error("Provided token [{}] has not been found in the ticket registry", (Object)token);
        } else if (OAuth20RevocationEndpointController.isRefreshToken(registryToken) || OAuth20RevocationEndpointController.isAccessToken(registryToken)) {
            if (!StringUtils.equals((CharSequence)clientId, (CharSequence)registryToken.getClientId())) {
                LOGGER.warn("Provided token [{}] has not been issued for the service [{}]", (Object)token, (Object)clientId);
                return OAuth20Utils.writeError(response, "invalid_request");
            }
            if (OAuth20RevocationEndpointController.isRefreshToken(registryToken)) {
                this.revokeToken((OAuth20RefreshToken)registryToken);
            } else {
                this.revokeToken(registryToken.getId());
            }
        } else {
            LOGGER.error("Provided token [{}] is either not a refresh token or not an access token", (Object)token);
            return OAuth20Utils.writeError(response, "invalid_request");
        }
        ModelAndView mv = new ModelAndView((View)new MappingJackson2JsonView());
        mv.setStatus((HttpStatusCode)HttpStatus.OK);
        return mv;
    }

    private boolean verifyRevocationRequest(WebContext context) throws Throwable {
        OAuth20TokenRequestValidator validator = ((List)((OAuth20ConfigurationContext)this.getConfigurationContext()).getAccessTokenGrantRequestValidators().getObject()).stream().filter(BeanSupplier::isNotProxy).filter(Unchecked.predicate(b -> b.supports(context))).findFirst().orElse(null);
        if (validator == null) {
            LOGGER.warn("Ignoring malformed request [{}] as no OAuth20 validator could declare support for its syntax", (Object)context.getFullRequestURL());
            return false;
        }
        return validator.validate(context);
    }
}

