/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

public enum RollingPolicySystemProperty {
    FILE_NAME_PATTERN("file-name-pattern", "logging.pattern.rolling-file-name"),
    CLEAN_HISTORY_ON_START("clean-history-on-start", "logging.file.clean-history-on-start"),
    MAX_FILE_SIZE("max-file-size", "logging.file.max-size"),
    TOTAL_SIZE_CAP("total-size-cap", "logging.file.total-size-cap"),
    MAX_HISTORY("max-history", "logging.file.max-history");

    private final String environmentVariableName = "LOGBACK_ROLLINGPOLICY_" + this.name();
    private final String applicationPropertyName;
    private final String deprecatedApplicationPropertyName;

    private RollingPolicySystemProperty(String applicationPropertyName, String deprecatedApplicationPropertyName) {
        this.applicationPropertyName = "logging.logback.rollingpolicy." + applicationPropertyName;
        this.deprecatedApplicationPropertyName = deprecatedApplicationPropertyName;
    }

    public String getEnvironmentVariableName() {
        return this.environmentVariableName;
    }

    String getApplicationPropertyName() {
        return this.applicationPropertyName;
    }

    String getDeprecatedApplicationPropertyName() {
        return this.deprecatedApplicationPropertyName;
    }
}

