/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.resource;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.inspektr.audit.spi.support.ParametersAsStringResourceResolver;

public class ProtocolSpecificationValidationAuditResourceResolver
extends ParametersAsStringResourceResolver {
    private final CasConfigurationProperties casProperties;

    @Override
    protected String[] createResource(Object[] args) {
        String[] stringArray;
        LinkedHashMap results = new LinkedHashMap();
        Arrays.stream(args).forEach(arg -> {
            if (arg instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)arg;
                results.put("renew", StringUtils.defaultIfBlank((CharSequence)request.getParameter("renew"), (CharSequence)"false"));
                results.put("gateway", StringUtils.defaultIfBlank((CharSequence)request.getParameter("gateway"), (CharSequence)"false"));
            }
            if (arg instanceof Assertion) {
                Assertion assertion = (Assertion)arg;
                Authentication authn = assertion.getPrimaryAuthentication();
                results.put("principal", authn.getPrincipal().getId());
                results.put("service", DigestUtils.abbreviate((String)assertion.getService().getId(), (int)this.casProperties.getAudit().getEngine().getAbbreviationLength()));
                if (this.casProperties.getAudit().getEngine().isIncludeValidationAssertion()) {
                    HashMap attributes = new HashMap(authn.getAttributes());
                    attributes.putAll(authn.getPrincipal().getAttributes());
                    results.put("attributes", attributes);
                }
            }
        });
        if (results.isEmpty()) {
            stringArray = ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.auditFormat.serialize(results);
        }
        return stringArray;
    }

    @Generated
    public ProtocolSpecificationValidationAuditResourceResolver(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

