/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Artifact;
import org.flowable.bpmn.model.Association;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Process;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ValidatorImpl;

public class AssociationValidator
extends ValidatorImpl {
    @Override
    public void validate(BpmnModel bpmnModel, List<ValidationError> errors) {
        Collection artifacts = bpmnModel.getGlobalArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!(artifact instanceof Association)) continue;
                this.validate(null, (Association)artifact, errors);
            }
        }
        for (Process process : bpmnModel.getProcesses()) {
            artifacts = process.getArtifacts();
            for (Artifact artifact : artifacts) {
                if (!(artifact instanceof Association)) continue;
                this.validate(process, (Association)artifact, errors);
            }
        }
    }

    protected void validate(Process process, Association association, List<ValidationError> errors) {
        if (StringUtils.isEmpty((CharSequence)association.getSourceRef())) {
            this.addError(errors, "flowable-asscociation-invalid-source-reference", process, (BaseElement)association, "association element missing attribute 'sourceRef'");
        }
        if (StringUtils.isEmpty((CharSequence)association.getTargetRef())) {
            this.addError(errors, "flowable-asscociation-invalid-target-reference", process, (BaseElement)association, "association element missing attribute 'targetRef'");
        }
    }
}

