/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import java.util.List;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class SetAsyncVariablesJobHandler
implements JobHandler {
    public static final String TYPE = "set-async-variables";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        ExecutionEntity executionEntity = (ExecutionEntity)variableScope;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        VariableService variableService = processEngineConfiguration.getVariableServiceConfiguration().getVariableService();
        List jobVariables = variableService.findVariableInstanceBySubScopeIdAndScopeType(executionEntity.getId(), "bpmnAsyncVariables");
        for (VariableInstanceEntity jobVariable : jobVariables) {
            if ("true".equalsIgnoreCase(jobVariable.getMetaInfo())) {
                executionEntity.setVariableLocal(jobVariable.getName(), jobVariable.getValue());
            } else {
                executionEntity.setVariable(jobVariable.getName(), jobVariable.getValue());
            }
            CountingEntityUtil.handleDeleteVariableInstanceEntityCount(jobVariable, false);
            variableService.deleteVariableInstance(jobVariable);
        }
    }
}

