/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CorrelationUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.EventInstanceBpmnUtil;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;

public class ReceiveEventTaskActivityBehavior
extends AbstractBpmnActivityBehavior {
    protected String receiveTaskId;
    protected String skipExpression;
    protected String eventDefinitionKey;

    public ReceiveEventTaskActivityBehavior(String eventDefinitionKey, String receiveTaskId, String skipExpression) {
        this.eventDefinitionKey = eventDefinitionKey;
        this.receiveTaskId = receiveTaskId;
        this.skipExpression = skipExpression;
    }

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(this.skipExpression, this.receiveTaskId, execution, commandContext);
        if (isSkipExpressionEnabled && SkipExpressionUtil.shouldSkipFlowElement(this.skipExpression, this.receiveTaskId, execution, commandContext)) {
            this.leave(execution);
            return;
        }
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        String eventDefinitionKey = this.getEventDefinitionKey(commandContext, executionEntity);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        EventSubscriptionEntity eventSubscription = (EventSubscriptionEntity)processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService().createEventSubscriptionBuilder().eventType(eventDefinitionKey).executionId(executionEntity.getId()).processInstanceId(executionEntity.getProcessInstanceId()).activityId(executionEntity.getCurrentActivityId()).processDefinitionId(executionEntity.getProcessDefinitionId()).scopeType("bpmn").tenantId(executionEntity.getTenantId()).configuration(CorrelationUtil.getCorrelationKey("eventCorrelationParameter", commandContext, executionEntity)).create();
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)eventSubscription);
        executionEntity.getEventSubscriptions().add(eventSubscription);
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        Object eventInstance = execution.getTransientVariables().get("eventInstance");
        if (eventInstance instanceof EventInstance) {
            EventInstanceBpmnUtil.handleEventInstanceOutParameters(execution, (BaseElement)execution.getCurrentFlowElement(), (EventInstance)eventInstance);
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        EventSubscriptionService eventSubscriptionService = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        List<EventSubscriptionEntity> eventSubscriptions = executionEntity.getEventSubscriptions();
        CommandContext commandContext = Context.getCommandContext();
        String eventDefinitionKey = this.getEventDefinitionKey(commandContext, executionEntity);
        for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
            if (!Objects.equals(eventDefinitionKey, eventSubscription.getEventType())) continue;
            eventSubscriptionService.deleteEventSubscription(eventSubscription);
            CountingEntityUtil.handleDeleteEventSubscriptionEntityCount((EventSubscription)eventSubscription);
        }
        super.leave(execution);
    }

    protected String getEventDefinitionKey(CommandContext commandContext, ExecutionEntity executionEntity) {
        Object key = null;
        if (StringUtils.isNotEmpty((CharSequence)this.eventDefinitionKey)) {
            Expression expression = CommandContextUtil.getProcessEngineConfiguration(commandContext).getExpressionManager().createExpression(this.eventDefinitionKey);
            key = expression.getValue((VariableContainer)executionEntity);
        }
        if (key == null) {
            throw new FlowableException("Could not resolve key for: " + this.eventDefinitionKey + " for " + String.valueOf(executionEntity));
        }
        return key.toString();
    }
}

