/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.authentication.storage;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.TrustedDevicesMultifactorProperties;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecordKeyGenerator;
import org.apereo.cas.trusted.authentication.storage.BaseMultifactorAuthenticationTrustStorage;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryMultifactorAuthenticationTrustStorage
extends BaseMultifactorAuthenticationTrustStorage {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryMultifactorAuthenticationTrustStorage.class);
    private final LoadingCache<String, MultifactorAuthenticationTrustRecord> storage;

    public InMemoryMultifactorAuthenticationTrustStorage(TrustedDevicesMultifactorProperties properties, CipherExecutor<Serializable, String> cipherExecutor, LoadingCache<String, MultifactorAuthenticationTrustRecord> storage, MultifactorAuthenticationTrustRecordKeyGenerator keyGenerationStrategy) {
        super(properties, cipherExecutor, keyGenerationStrategy);
        this.storage = storage;
    }

    @Override
    public void remove(String key) {
        this.storage.asMap().keySet().removeIf(k -> k.equalsIgnoreCase(key));
    }

    @Override
    public void remove(ZonedDateTime expirationDate) {
        LinkedHashSet results = this.storage.asMap().values().stream().filter(entry -> entry.getExpirationDate() != null).filter(entry -> {
            Date expDate = DateTimeUtils.dateOf((ChronoZonedDateTime)expirationDate);
            return expDate.compareTo(entry.getExpirationDate()) >= 0;
        }).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        LOGGER.info("Found [{}] expired trusted-device records", (Object)results.size());
        if (!results.isEmpty()) {
            results.forEach(entry -> this.storage.invalidate((Object)entry.getRecordKey()));
            LOGGER.info("Invalidated and removed [{}] expired records", (Object)results.size());
        }
    }

    @Override
    public Set<? extends MultifactorAuthenticationTrustRecord> get(ZonedDateTime onOrAfterDate) {
        this.remove();
        return this.storage.asMap().values().stream().filter(entry -> entry.getExpirationDate() != null && (entry.getRecordDate().isEqual(onOrAfterDate) || entry.getRecordDate().isAfter(onOrAfterDate))).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<? extends MultifactorAuthenticationTrustRecord> get(String principal) {
        this.remove();
        return this.storage.asMap().values().stream().filter(entry -> entry.getPrincipal().equalsIgnoreCase(principal)).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public MultifactorAuthenticationTrustRecord get(long id) {
        this.remove();
        Optional<MultifactorAuthenticationTrustRecord> result = this.storage.asMap().values().stream().filter(entry -> entry.getId() == id).sorted().findFirst();
        if (result.isPresent()) {
            MultifactorAuthenticationTrustRecord record = result.get();
            LOGGER.trace("Found multifactor authentication trust record [{}]", (Object)record);
            return record;
        }
        return null;
    }

    @Override
    public Set<? extends MultifactorAuthenticationTrustRecord> getAll() {
        this.remove();
        return new TreeSet(this.storage.asMap().values());
    }

    @Override
    public MultifactorAuthenticationTrustRecord saveInternal(MultifactorAuthenticationTrustRecord record) {
        this.storage.put((Object)record.getRecordKey(), (Object)record);
        return record;
    }

    @Generated
    public LoadingCache<String, MultifactorAuthenticationTrustRecord> getStorage() {
        return this.storage;
    }
}

