/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataSealerException;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.SerializeSupport;
import net.shibboleth.shared.xml.XMLParserException;
import net.shibboleth.shared.xml.impl.BasicParserPool;
import org.opensaml.storage.MutableStorageRecord;
import org.opensaml.storage.impl.client.AbstractClientStorageServiceStore;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.opensaml.storage.impl.client.ClientStorageServiceOperation;
import org.opensaml.storage.impl.client.ClientStorageServiceStore;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLClientStorageServiceStore
extends AbstractClientStorageServiceStore {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(XMLClientStorageServiceStore.class);
    @Nonnull
    private final ParserPool parserPool;

    public XMLClientStorageServiceStore(@Nonnull ParserPool pool) {
        this.parserPool = (ParserPool)Constraint.isNotNull((Object)pool, (String)"ParserPool cannot be null");
    }

    @Override
    public void doLoad(@Nullable @NotEmpty String raw) throws IOException {
        try {
            Element rootElement;
            Document doc = this.parserPool.parse((Reader)new StringReader(raw));
            Element element = rootElement = doc != null ? doc.getDocumentElement() : null;
            if (rootElement == null || !"map".equals(rootElement.getNodeName())) {
                throw new IOException("Found invalid data structure while parsing context map");
            }
            Element contextElement = ElementSupport.getFirstChildElement((Node)rootElement);
            while (contextElement != null && "c".equals(contextElement.getNodeName())) {
                String contextId = contextElement.getAttribute("id");
                if (!Strings.isNullOrEmpty((String)contextId)) {
                    Map<String, MutableStorageRecord<?>> dataMap = this.getContextMap().get(contextId);
                    if (dataMap == null) {
                        dataMap = new HashMap();
                        this.getContextMap().put(contextId, dataMap);
                    }
                    Element keyElement = ElementSupport.getFirstChildElement((Node)contextElement);
                    while (keyElement != null && "k".equals(keyElement.getNodeName())) {
                        String keyId = keyElement.getAttribute("id");
                        if (!Strings.isNullOrEmpty((String)keyId)) {
                            Long exp = null;
                            if (keyElement.hasAttribute("x")) {
                                exp = Long.valueOf(keyElement.getAttribute("x"));
                            }
                            dataMap.put(keyId, new MutableStorageRecord(keyElement.getTextContent(), exp));
                        }
                        keyElement = ElementSupport.getNextSiblingElement((Node)keyElement);
                    }
                }
                contextElement = ElementSupport.getNextSiblingElement((Node)contextElement);
            }
            this.setDirty(false);
        }
        catch (XMLParserException e) {
            this.log.error("Found invalid data structure while parsing context map", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    @Nullable
    public ClientStorageServiceOperation save(@Nonnull ClientStorageService storageService) throws IOException {
        if (!this.isDirty()) {
            this.log.trace("{} Storage state has not been modified, save operation skipped", (Object)storageService.getLogPrefix());
            return null;
        }
        ClientStorageService.ClientStorageSource source = this.getSource();
        if (source == null) {
            throw new IOException("Client storage medium not set");
        }
        if (this.getContextMap().isEmpty()) {
            this.log.trace("{} Data is empty", (Object)storageService.getLogPrefix());
            this.setDirty(false);
            return new ClientStorageServiceOperation(storageService.ensureId(), storageService.getStorageName(), null, source);
        }
        long exp = 0L;
        long now = System.currentTimeMillis();
        boolean empty = true;
        try {
            Document doc = this.parserPool.newDocument();
            Element rootElement = doc.createElement("map");
            for (Map.Entry<String, Map<String, MutableStorageRecord<?>>> context : this.getContextMap().entrySet()) {
                if (context.getValue().isEmpty()) continue;
                Element contextElement = doc.createElement("c");
                contextElement.setAttribute("id", context.getKey());
                for (Map.Entry<String, MutableStorageRecord<?>> entry : context.getValue().entrySet()) {
                    MutableStorageRecord<?> record = entry.getValue();
                    Long recexp = record.getExpiration();
                    if (recexp != null && recexp <= now) continue;
                    empty = false;
                    Element keyElement = doc.createElement("k");
                    keyElement.setAttribute("id", entry.getKey());
                    keyElement.setTextContent(record.getValue());
                    if (recexp != null) {
                        keyElement.setAttribute("x", recexp.toString());
                        exp = Math.max(exp, recexp);
                    }
                    contextElement.appendChild(keyElement);
                }
                rootElement.appendChild(contextElement);
            }
            if (empty) {
                this.log.trace("{} Data is empty", (Object)storageService.getLogPrefix());
                this.setDirty(false);
                return new ClientStorageServiceOperation(storageService.ensureId(), storageService.getStorageName(), null, source);
            }
            assert (rootElement != null);
            String raw = SerializeSupport.nodeToString((Node)rootElement);
            this.log.trace("{} Size of data before encryption is {}", (Object)storageService.getLogPrefix(), (Object)raw.length());
            this.log.trace("{} Data before encryption is {}", (Object)storageService.getLogPrefix(), (Object)raw);
            try {
                String wrapped = storageService.getDataSealer().wrap(raw, exp > 0L ? Instant.ofEpochMilli(exp) : Instant.now().plus(Duration.ofDays(1L)));
                this.log.trace("{} Size of data after encryption is {}", (Object)storageService.getLogPrefix(), (Object)wrapped.length());
                this.setDirty(false);
                return new ClientStorageServiceOperation(storageService.ensureId(), storageService.getStorageName(), wrapped, source);
            }
            catch (DataSealerException e) {
                throw new IOException(e);
            }
        }
        catch (XMLParserException e) {
            throw new IOException(e);
        }
    }

    public static class XMLClientStorageServiceStoreFactory
    extends AbstractInitializableComponent
    implements ClientStorageServiceStore.Factory {
        @Nonnull
        private final ParserPool parserPool = new BasicParserPool();

        protected void doInitialize() throws ComponentInitializationException {
            super.doInitialize();
            ((BasicParserPool)this.parserPool).setNamespaceAware(false);
            ((BasicParserPool)this.parserPool).initialize();
        }

        protected void doDestroy() {
            ((BasicParserPool)this.parserPool).destroy();
        }

        @Override
        @Nonnull
        public ClientStorageServiceStore load(@Nullable @NotEmpty String raw, @Nonnull ClientStorageService.ClientStorageSource src) {
            XMLClientStorageServiceStore store = new XMLClientStorageServiceStore(this.parserPool);
            store.load(raw, src);
            return store;
        }
    }
}

