/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Strings;
import org.apache.cxf.transport.http.auth.DefaultBasicAuthSupplier;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.lib.to.SRARouteTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.SRARouteDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.SRARoute;
import org.apache.syncope.core.provisioning.api.data.SRARouteDataBinder;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.security.access.prepost.PreAuthorize;

public class SRARouteLogic
extends AbstractTransactionalLogic<SRARouteTO> {
    protected final SRARouteDAO routeDAO;
    protected final SRARouteDataBinder binder;
    protected final EntityFactory entityFactory;
    protected final ServiceOps serviceOps;
    protected final SecurityProperties securityProperties;

    public SRARouteLogic(SRARouteDAO routeDAO, SRARouteDataBinder binder, EntityFactory entityFactory, ServiceOps serviceOps, SecurityProperties securityProperties) {
        this.routeDAO = routeDAO;
        this.binder = binder;
        this.entityFactory = entityFactory;
        this.serviceOps = serviceOps;
        this.securityProperties = securityProperties;
    }

    @PreAuthorize(value="isAuthenticated()")
    public List<SRARouteTO> list() {
        return this.routeDAO.findAll().stream().map(arg_0 -> ((SRARouteDataBinder)this.binder).getSRARouteTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('SRA_ROUTE_CREATE')")
    public SRARouteTO create(SRARouteTO routeTO) {
        SRARoute route = (SRARoute)this.entityFactory.newEntity(SRARoute.class);
        this.binder.getSRARoute(route, routeTO);
        return this.binder.getSRARouteTO((SRARoute)this.routeDAO.save((Entity)route));
    }

    @PreAuthorize(value="isAuthenticated()")
    public SRARouteTO read(String key) {
        SRARoute route = (SRARoute)this.routeDAO.findById(key).orElseThrow(() -> new NotFoundException("SRARoute " + key));
        return this.binder.getSRARouteTO(route);
    }

    @PreAuthorize(value="hasRole('SRA_ROUTE_UPDATE')")
    public SRARouteTO update(SRARouteTO routeTO) {
        SRARoute route = (SRARoute)this.routeDAO.findById(routeTO.getKey()).orElseThrow(() -> new NotFoundException("SRARoute " + routeTO.getKey()));
        this.binder.getSRARoute(route, routeTO);
        return this.binder.getSRARouteTO((SRARoute)this.routeDAO.save((Entity)route));
    }

    @PreAuthorize(value="hasRole('SRA_ROUTE_DELETE')")
    public SRARouteTO delete(String key) {
        SRARoute route = (SRARoute)this.routeDAO.findById(key).orElseThrow(() -> new NotFoundException("SRARoute " + key));
        SRARouteTO deleted = this.binder.getSRARouteTO(route);
        this.routeDAO.delete((Entity)route);
        return deleted;
    }

    @PreAuthorize(value="hasRole('SRA_ROUTE_PUSH')")
    public void pushToSRA() {
        HttpClient client = HttpClient.newHttpClient();
        try {
            this.serviceOps.list(NetworkService.Type.SRA).forEach(sra -> client.sendAsync(HttpRequest.newBuilder(URI.create(Strings.CS.appendIfMissing(sra.getAddress(), (CharSequence)"/", new CharSequence[0]) + "actuator/gateway/refresh")).header("Authorization", DefaultBasicAuthSupplier.getBasicAuthHeader((String)this.securityProperties.getAnonymousUser(), (String)this.securityProperties.getAnonymousKey())).POST(HttpRequest.BodyPublishers.noBody()).build(), HttpResponse.BodyHandlers.discarding()).thenAcceptAsync(response -> LOG.info("Pushed to SRA instance {} with HTTP status: {}", (Object)sra.getAddress(), (Object)response.statusCode())));
        }
        catch (KeymasterException e) {
            throw new NotFoundException("Could not find any WA instance", (Exception)((Object)e));
        }
    }

    protected SRARouteTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args) && ("create".equals(method.getName()) || "update".equals(method.getName()) || "delete".equals(method.getName()))) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof SRARouteTO)) continue;
                SRARouteTO sRARouteTO = (SRARouteTO)object;
                key = sRARouteTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getSRARouteTO((SRARoute)this.routeDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

