/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDashboardResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, GetDashboardResponse> {
    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardArn").getter(GetDashboardResponse.getter(GetDashboardResponse::dashboardArn)).setter(GetDashboardResponse.setter(Builder::dashboardArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()}).build();
    private static final SdkField<String> DASHBOARD_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardBody").getter(GetDashboardResponse.getter(GetDashboardResponse::dashboardBody)).setter(GetDashboardResponse.setter(Builder::dashboardBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardBody").build()}).build();
    private static final SdkField<String> DASHBOARD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardName").getter(GetDashboardResponse.getter(GetDashboardResponse::dashboardName)).setter(GetDashboardResponse.setter(Builder::dashboardName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ARN_FIELD, DASHBOARD_BODY_FIELD, DASHBOARD_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDashboardResponse.memberNameToFieldInitializer();
    private final String dashboardArn;
    private final String dashboardBody;
    private final String dashboardName;

    private GetDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardArn = builder.dashboardArn;
        this.dashboardBody = builder.dashboardBody;
        this.dashboardName = builder.dashboardName;
    }

    public final String dashboardArn() {
        return this.dashboardArn;
    }

    public final String dashboardBody() {
        return this.dashboardBody;
    }

    public final String dashboardName() {
        return this.dashboardName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDashboardResponse)) {
            return false;
        }
        GetDashboardResponse other = (GetDashboardResponse)((Object)obj);
        return Objects.equals(this.dashboardArn(), other.dashboardArn()) && Objects.equals(this.dashboardBody(), other.dashboardBody()) && Objects.equals(this.dashboardName(), other.dashboardName());
    }

    public final String toString() {
        return ToString.builder((String)"GetDashboardResponse").add("DashboardArn", (Object)this.dashboardArn()).add("DashboardBody", (Object)this.dashboardBody()).add("DashboardName", (Object)this.dashboardName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardArn": {
                return Optional.ofNullable(clazz.cast(this.dashboardArn()));
            }
            case "DashboardBody": {
                return Optional.ofNullable(clazz.cast(this.dashboardBody()));
            }
            case "DashboardName": {
                return Optional.ofNullable(clazz.cast(this.dashboardName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DashboardArn", DASHBOARD_ARN_FIELD);
        map.put("DashboardBody", DASHBOARD_BODY_FIELD);
        map.put("DashboardName", DASHBOARD_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDashboardResponse, T> g) {
        return obj -> g.apply((GetDashboardResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private String dashboardArn;
        private String dashboardBody;
        private String dashboardName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDashboardResponse model) {
            super(model);
            this.dashboardArn(model.dashboardArn);
            this.dashboardBody(model.dashboardBody);
            this.dashboardName(model.dashboardName);
        }

        public final String getDashboardArn() {
            return this.dashboardArn;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final String getDashboardBody() {
            return this.dashboardBody;
        }

        public final void setDashboardBody(String dashboardBody) {
            this.dashboardBody = dashboardBody;
        }

        @Override
        public final Builder dashboardBody(String dashboardBody) {
            this.dashboardBody = dashboardBody;
            return this;
        }

        public final String getDashboardName() {
            return this.dashboardName;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        @Override
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        @Override
        public GetDashboardResponse build() {
            return new GetDashboardResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDashboardResponse> {
        public Builder dashboardArn(String var1);

        public Builder dashboardBody(String var1);

        public Builder dashboardName(String var1);
    }
}

