/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.jms;

import io.micrometer.common.KeyValue;
import io.micrometer.common.docs.KeyName;
import io.micrometer.common.lang.Nullable;
import io.micrometer.jakarta9.instrument.jms.JmsObservationDocumentation;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;

class JmsKeyValues {
    private static final KeyValue DESTINATION_TEMPORARY = KeyValue.of((KeyName)JmsObservationDocumentation.LowCardinalityKeyNames.DESTINATION_TEMPORARY, (String)"true");
    private static final KeyValue DESTINATION_DURABLE = KeyValue.of((KeyName)JmsObservationDocumentation.LowCardinalityKeyNames.DESTINATION_TEMPORARY, (String)"false");
    private static final KeyValue MESSAGE_CONVERSATION_ID_UNKNOWN = KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.CONVERSATION_ID, (String)"unknown");
    private static final KeyValue DESTINATION_NAME_UNKNOWN = KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, (String)"unknown");
    private static final KeyValue MESSAGE_ID_UNKNOWN = KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.MESSAGE_ID, (String)"unknown");

    private JmsKeyValues() {
    }

    static KeyValue conversationId(@Nullable Message message) {
        try {
            if (message == null || message.getJMSCorrelationID() == null) {
                return MESSAGE_CONVERSATION_ID_UNKNOWN;
            }
            return KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.CONVERSATION_ID, (String)message.getJMSCorrelationID());
        }
        catch (JMSException exc) {
            return MESSAGE_CONVERSATION_ID_UNKNOWN;
        }
    }

    static KeyValue destinationName(@Nullable Message message) {
        if (message == null) {
            return DESTINATION_NAME_UNKNOWN;
        }
        try {
            Queue queue;
            String queueName;
            Destination destination = message.getJMSDestination();
            if (destination instanceof Queue && (queueName = (queue = (Queue)destination).getQueueName()) != null) {
                return KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, (String)queueName);
            }
            return JmsKeyValues.getKeyValueTopic(destination);
        }
        catch (JMSException e) {
            return DESTINATION_NAME_UNKNOWN;
        }
    }

    static KeyValue messageId(@Nullable Message message) {
        try {
            if (message == null || message.getJMSMessageID() == null) {
                return MESSAGE_ID_UNKNOWN;
            }
            return KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.MESSAGE_ID, (String)message.getJMSMessageID());
        }
        catch (JMSException exc) {
            return MESSAGE_ID_UNKNOWN;
        }
    }

    static KeyValue temporaryDestination(@Nullable Message message) {
        try {
            Destination destination;
            if (message != null && ((destination = message.getJMSDestination()) instanceof TemporaryQueue || destination instanceof TemporaryTopic)) {
                return DESTINATION_TEMPORARY;
            }
            return DESTINATION_DURABLE;
        }
        catch (JMSException exc) {
            return DESTINATION_DURABLE;
        }
    }

    private static KeyValue getKeyValueTopic(Destination jmsDestination) throws JMSException {
        Topic topic;
        String topicName;
        if (jmsDestination instanceof Topic && (topicName = (topic = (Topic)jmsDestination).getTopicName()) != null) {
            return KeyValue.of((KeyName)JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, (String)topicName);
        }
        return DESTINATION_NAME_UNKNOWN;
    }
}

