/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.user;

import com.okta.commons.lang.Classes;
import com.okta.sdk.client.Client;
import com.okta.sdk.resource.user.AuthenticationProvider;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserNextLogin;
import com.okta.sdk.resource.user.type.UserType;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface UserBuilder {
    public static UserBuilder instance() {
        return (UserBuilder)Classes.newInstance((String)"com.okta.sdk.impl.resource.DefaultUserBuilder");
    }

    public UserBuilder setPassword(char[] var1);

    public UserBuilder usePasswordHookForImport();

    public UserBuilder usePasswordHookForImport(String var1);

    public UserBuilder setSecurityQuestion(String var1);

    public UserBuilder setSecurityQuestionAnswer(String var1);

    public UserBuilder setEmail(String var1);

    public UserBuilder setFirstName(String var1);

    public UserBuilder setLastName(String var1);

    public UserBuilder setLogin(String var1);

    public UserBuilder setMobilePhone(String var1);

    public UserBuilder setSecondEmail(String var1);

    public UserBuilder setActive(Boolean var1);

    public UserBuilder setProvider(AuthenticationProvider var1);

    public UserBuilder setType(UserType var1);

    public UserBuilder setType(String var1);

    public UserBuilder setProfileProperties(Map<String, Object> var1);

    public UserBuilder putAllProfileProperties(Map<String, Object> var1);

    public UserBuilder putProfileProperty(String var1, Object var2);

    default public UserBuilder setGroups(String ... groupIds) {
        return this.setGroups(Arrays.stream(groupIds).collect(Collectors.toSet()));
    }

    public UserBuilder setGroups(Set<String> var1);

    public UserBuilder addGroup(String var1);

    public UserBuilder setNextLogin(UserNextLogin var1);

    public UserBuilder setBcryptPasswordHash(String var1, String var2, int var3);

    public UserBuilder setSha256PasswordHash(String var1, String var2, String var3);

    public UserBuilder setSha512PasswordHash(String var1, String var2, String var3);

    public UserBuilder setSha1PasswordHash(String var1, String var2, String var3);

    public User buildAndCreate(Client var1);
}

