/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationManagerAfterReactiveMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeReactiveMethodInterceptor;
import org.springframework.security.authorization.method.PostAuthorizeReactiveAuthorizationManager;
import org.springframework.security.authorization.method.PostFilterAuthorizationReactiveMethodInterceptor;
import org.springframework.security.authorization.method.PreAuthorizeReactiveAuthorizationManager;
import org.springframework.security.authorization.method.PreFilterAuthorizationReactiveMethodInterceptor;
import org.springframework.security.config.core.GrantedAuthorityDefaults;

@Configuration(proxyBeanMethods=false)
final class ReactiveAuthorizationManagerMethodSecurityConfiguration {
    ReactiveAuthorizationManagerMethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    PreFilterAuthorizationReactiveMethodInterceptor preFilterInterceptor(MethodSecurityExpressionHandler expressionHandler) {
        return new PreFilterAuthorizationReactiveMethodInterceptor(expressionHandler);
    }

    @Bean
    @Role(value=2)
    AuthorizationManagerBeforeReactiveMethodInterceptor preAuthorizeInterceptor(MethodSecurityExpressionHandler expressionHandler) {
        PreAuthorizeReactiveAuthorizationManager authorizationManager = new PreAuthorizeReactiveAuthorizationManager(expressionHandler);
        return AuthorizationManagerBeforeReactiveMethodInterceptor.preAuthorize((ReactiveAuthorizationManager)authorizationManager);
    }

    @Bean
    @Role(value=2)
    PostFilterAuthorizationReactiveMethodInterceptor postFilterInterceptor(MethodSecurityExpressionHandler expressionHandler) {
        return new PostFilterAuthorizationReactiveMethodInterceptor(expressionHandler);
    }

    @Bean
    @Role(value=2)
    AuthorizationManagerAfterReactiveMethodInterceptor postAuthorizeInterceptor(MethodSecurityExpressionHandler expressionHandler) {
        PostAuthorizeReactiveAuthorizationManager authorizationManager = new PostAuthorizeReactiveAuthorizationManager(expressionHandler);
        return AuthorizationManagerAfterReactiveMethodInterceptor.postAuthorize((ReactiveAuthorizationManager)authorizationManager);
    }

    @Bean
    @Role(value=2)
    DefaultMethodSecurityExpressionHandler methodSecurityExpressionHandler(@Autowired(required=false) GrantedAuthorityDefaults grantedAuthorityDefaults) {
        DefaultMethodSecurityExpressionHandler handler = new DefaultMethodSecurityExpressionHandler();
        if (grantedAuthorityDefaults != null) {
            handler.setDefaultRolePrefix(grantedAuthorityDefaults.getRolePrefix());
        }
        return handler;
    }
}

