/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.user;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.role.RoleAssignmentType;
import com.okta.sdk.resource.role.RoleType;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.RoleStatus;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultRole
extends AbstractInstanceResource<Role>
implements Role {
    private static final MapProperty embeddedProperty = new MapProperty("_embedded");
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final EnumProperty<RoleAssignmentType> assignmentTypeProperty = new EnumProperty<RoleAssignmentType>("assignmentType", RoleAssignmentType.class);
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty descriptionProperty = new StringProperty("description");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final StringProperty labelProperty = new StringProperty("label");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final EnumProperty<RoleStatus> statusProperty = new EnumProperty<RoleStatus>("status", RoleStatus.class);
    private static final EnumProperty<RoleType> typeProperty = new EnumProperty<RoleType>("type", RoleType.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultRole.createPropertyDescriptorMap(embeddedProperty, linksProperty, assignmentTypeProperty, createdProperty, descriptionProperty, idProperty, labelProperty, lastUpdatedProperty, statusProperty, typeProperty);

    public DefaultRole(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultRole(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Role.class;
    }

    public Map<String, Object> getEmbedded() {
        return this.getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public RoleAssignmentType getAssignmentType() {
        return this.getEnumProperty(assignmentTypeProperty);
    }

    public Role setAssignmentType(RoleAssignmentType assignmentType) {
        this.setProperty(assignmentTypeProperty, (Object)assignmentType);
        return this;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getDescription() {
        return this.getString(descriptionProperty);
    }

    public Role setDescription(String description) {
        this.setProperty(descriptionProperty, (Object)description);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public String getLabel() {
        return this.getString(labelProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public RoleStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public RoleType getType() {
        return this.getEnumProperty(typeProperty);
    }

    public Role setType(RoleType type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public void addAdminGroupTarget(String targetGroupId) {
        String roleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/groups/{groupId}/roles/{roleId}/targets/groups/{targetGroupId}");
        String groupId = pathArgs.get("groupId");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)targetGroupId, (String)"'targetGroupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/groups/" + targetGroupId + "";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()), this, queryArgs, (Map<String, List<String>>)headers);
    }

    public void addAppTargetToAdminRoleForUser(String appName) {
        String roleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}");
        String userId = pathArgs.get("userId");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()), this, queryArgs, (Map<String, List<String>>)headers);
    }

    public void addAppInstanceTargetToAdminRole(String appName, String applicationId) {
        String roleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}");
        String groupId = pathArgs.get("groupId");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        Assert.hasText((String)applicationId, (String)"'applicationId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "/" + applicationId + "";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()), this, queryArgs, (Map<String, List<String>>)headers);
    }

    public void addAppTargetToAppAdminRoleForUser(String appName, String applicationId) {
        String roleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}");
        String userId = pathArgs.get("userId");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        Assert.hasText((String)applicationId, (String)"'applicationId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "/" + applicationId + "";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()), this, queryArgs, (Map<String, List<String>>)headers);
    }

    public void addAllAppsAsTargetToRole() {
        String roleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps");
        String userId = pathArgs.get("userId");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()), this, queryArgs, (Map<String, List<String>>)headers);
    }

    public void addAppTargetToAdminRole(String appName) {
        String roleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}");
        String groupId = pathArgs.get("groupId");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()), this, queryArgs, (Map<String, List<String>>)headers);
    }
}

