/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.services.directory.Directory;
import com.google.api.services.directory.model.Alias;
import com.google.api.services.directory.model.Group;
import com.google.api.services.directory.model.Member;
import com.google.api.services.directory.model.OrgUnit;
import com.google.api.services.directory.model.User;
import com.google.api.services.directory.model.UserMakeAdmin;
import com.google.api.services.directory.model.UserPhoto;
import com.google.api.services.licensing.Licensing;
import com.google.api.services.licensing.model.LicenseAssignment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.tirasa.connid.bundles.googleapps.GoogleApiExecutor;
import net.tirasa.connid.bundles.googleapps.GoogleAppsConfiguration;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import net.tirasa.connid.bundles.googleapps.GroupHandler;
import net.tirasa.connid.bundles.googleapps.LicenseAssignmentsHandler;
import net.tirasa.connid.bundles.googleapps.MembersHandler;
import net.tirasa.connid.bundles.googleapps.OrgunitsHandler;
import net.tirasa.connid.bundles.googleapps.RequestResultHandler;
import net.tirasa.connid.bundles.googleapps.UserHandler;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.exceptions.RetryableException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public class GoogleAppsCreate {
    private static final Log LOG = Log.getLog(GoogleAppsCreate.class);
    private final GoogleAppsConfiguration configuration;
    private final ObjectClass objectClass;
    private final Set<Attribute> createAttributes;

    public GoogleAppsCreate(GoogleAppsConfiguration configuration, ObjectClass objectClass, Set<Attribute> createAttributes) {
        this.configuration = configuration;
        this.objectClass = objectClass;
        this.createAttributes = createAttributes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Uid createUser(AttributesAccessor accessor) {
        Attribute groups;
        Attribute isAdmin;
        Attribute photo;
        Uid uid = GoogleApiExecutor.execute(UserHandler.createUser(this.configuration.getDirectory().users(), accessor, this.configuration.getCustomSchemasJSON()), new RequestResultHandler<Directory.Users.Insert, User, Uid>(){

            @Override
            public Uid handleResult(Directory.Users.Insert request, User value) {
                LOG.ok("New User is created: {0} with ETag {1}", new Object[]{value.getId(), value.getEtag()});
                return new Uid(value.getId(), value.getEtag());
            }
        });
        List aliases = accessor.findList("aliases");
        if (null != aliases) {
            Directory.Users.Aliases aliasesService = this.configuration.getDirectory().users().aliases();
            for (Object alias : aliases) {
                if (alias instanceof String) {
                    String id = GoogleApiExecutor.execute(UserHandler.createUserAlias(aliasesService, uid.getUidValue(), (String)alias), new RequestResultHandler<Directory.Users.Aliases.Insert, Alias, String>(){

                        @Override
                        public String handleResult(Directory.Users.Aliases.Insert request, Alias value) {
                            return value == null ? null : value.getId();
                        }
                    });
                    if (null == id) continue;
                    continue;
                }
                if (null == alias) continue;
                RetryableException e = RetryableException.wrap((String)("Invalid attribute value: " + String.valueOf(alias)), (Uid)uid);
                e.initCause((Throwable)new InvalidAttributeValueException("Attribute 'aliases' must be a String list"));
                throw e;
            }
        }
        if (null != (photo = accessor.find("__PHOTO__"))) {
            Object photoObject = AttributeUtil.getSingleValue((Attribute)photo);
            if (photoObject instanceof byte[]) {
                String id = GoogleApiExecutor.execute(UserHandler.createUpdateUserPhoto(this.configuration.getDirectory().users().photos(), uid.getUidValue(), (byte[])photoObject), new RequestResultHandler<Directory.Users.Photos.Update, UserPhoto, String>(){

                    @Override
                    public String handleResult(Directory.Users.Photos.Update request, UserPhoto value) {
                        return value == null ? null : value.getId();
                    }
                });
                if (null != id) {
                    // empty if block
                }
            } else if (null != photoObject) {
                RetryableException e = RetryableException.wrap((String)("Invalid attribute value: " + String.valueOf(photoObject)), (Uid)uid);
                e.initCause((Throwable)new InvalidAttributeValueException("Attribute 'photo' must be a single byte[] value"));
                throw e;
            }
        }
        if (null != (isAdmin = accessor.find("isAdmin"))) {
            try {
                Boolean isAdminValue = AttributeUtil.getBooleanValue((Attribute)isAdmin);
                if (null != isAdminValue && isAdminValue.booleanValue()) {
                    UserMakeAdmin content = new UserMakeAdmin();
                    content.setStatus(isAdminValue);
                    GoogleApiExecutor.execute(this.configuration.getDirectory().users().makeAdmin(uid.getUidValue(), content), new RequestResultHandler<Directory.Users.MakeAdmin, Void, Void>(){

                        @Override
                        public Void handleResult(Directory.Users.MakeAdmin request, Void value) {
                            return null;
                        }
                    });
                }
            }
            catch (Exception e) {
                throw ConnectorException.wrap((Throwable)e);
            }
        }
        if (null != (groups = accessor.find(PredefinedAttributes.GROUPS_NAME)) && null != groups.getValue()) {
            Directory.Members service = this.configuration.getDirectory().members();
            if (!groups.getValue().isEmpty()) {
                ArrayList<Directory.Members.Insert> addGroups = new ArrayList<Directory.Members.Insert>();
                for (Object group : groups.getValue()) {
                    if (group instanceof String) {
                        String email = accessor.getName().getNameValue();
                        addGroups.add(MembersHandler.create(service, (String)group, email, null));
                        continue;
                    }
                    if (null == group) continue;
                    throw new InvalidAttributeValueException("Attribute '__GROUPS__' must be a String list");
                }
                for (Directory.Members.Insert insert : addGroups) {
                    GoogleApiExecutor.execute(insert, new RequestResultHandler<Directory.Members.Insert, Member, Object>(){

                        @Override
                        public Object handleResult(Directory.Members.Insert request, Member value) {
                            return null;
                        }

                        @Override
                        public Object handleDuplicate(IOException e) {
                            return null;
                        }
                    });
                }
            }
        }
        return uid;
    }

    private Uid createGroup(AttributesAccessor accessor) {
        List members;
        Uid uid = GoogleApiExecutor.execute(GroupHandler.create(this.configuration.getDirectory().groups(), accessor), new RequestResultHandler<Directory.Groups.Insert, Group, Uid>(){

            @Override
            public Uid handleResult(Directory.Groups.Insert request, Group value) {
                LOG.ok("New Group is created:{0}", new Object[]{value.getEmail()});
                return new Uid(value.getId(), value.getEtag());
            }
        });
        List aliases = accessor.findList("aliases");
        if (null != aliases) {
            Directory.Groups.Aliases aliasesService = this.configuration.getDirectory().groups().aliases();
            for (Object alias : aliases) {
                if (alias instanceof String) {
                    String id = GoogleApiExecutor.execute(GroupHandler.createGroupAlias(aliasesService, uid.getUidValue(), (String)alias), new RequestResultHandler<Directory.Groups.Aliases.Insert, Alias, String>(){

                        @Override
                        public String handleResult(Directory.Groups.Aliases.Insert request, Alias value) {
                            return value == null ? null : value.getId();
                        }
                    });
                    if (null != id) continue;
                }
                if (null == alias) continue;
                RetryableException e = RetryableException.wrap((String)("Invalid attribute value: " + String.valueOf(alias)), (Uid)uid);
                e.initCause((Throwable)new InvalidAttributeValueException("Attribute 'aliases' must be a String list"));
                throw e;
            }
        }
        if (null != (members = accessor.findList("__MEMBERS__"))) {
            Directory.Members membersService = this.configuration.getDirectory().members();
            for (Object member : members) {
                if (member instanceof Map) {
                    String email = (String)((Map)member).get("email");
                    String role = (String)((Map)member).get("role");
                    String id = GoogleApiExecutor.execute(MembersHandler.create(membersService, uid.getUidValue(), email, role), new RequestResultHandler<Directory.Members.Insert, Member, String>(){

                        @Override
                        public String handleResult(Directory.Members.Insert request, Member value) {
                            return value == null ? null : value.getId();
                        }
                    });
                    if (null != id) continue;
                }
                if (null == member) continue;
                RetryableException e = RetryableException.wrap((String)("Invalid attribute value: " + String.valueOf(member)), (Uid)uid);
                e.initCause((Throwable)new InvalidAttributeValueException("Attribute 'members' must be a Map list"));
                throw e;
            }
        }
        return uid;
    }

    public Uid execute() {
        AttributesAccessor accessor = new AttributesAccessor(this.createAttributes);
        if (ObjectClass.ACCOUNT.equals((Object)this.objectClass)) {
            return this.createUser(accessor);
        }
        if (ObjectClass.GROUP.equals((Object)this.objectClass)) {
            return this.createGroup(accessor);
        }
        if (GoogleAppsUtil.MEMBER.equals((Object)this.objectClass)) {
            return GoogleApiExecutor.execute(MembersHandler.create(this.configuration.getDirectory().members(), accessor), new RequestResultHandler<Directory.Members.Insert, Member, Uid>(){

                @Override
                public Uid handleResult(Directory.Members.Insert request, Member value) {
                    LOG.ok("New Member is created:{0}/{1}", new Object[]{request.getGroupKey(), value.getEmail()});
                    return MembersHandler.generateUid(request.getGroupKey(), value);
                }
            });
        }
        if (GoogleAppsUtil.ORG_UNIT.equals((Object)this.objectClass)) {
            return GoogleApiExecutor.execute(OrgunitsHandler.create(this.configuration.getDirectory().orgunits(), accessor), new RequestResultHandler<Directory.Orgunits.Insert, OrgUnit, Uid>(){

                @Override
                public Uid handleResult(Directory.Orgunits.Insert request, OrgUnit value) {
                    LOG.ok("New OrgUnit is created:{0}", new Object[]{value.getName()});
                    return OrgunitsHandler.generateUid(value);
                }
            });
        }
        if (GoogleAppsUtil.LICENSE_ASSIGNMENT.equals((Object)this.objectClass)) {
            return GoogleApiExecutor.execute(LicenseAssignmentsHandler.create(this.configuration.getLicensing().licenseAssignments(), accessor), new RequestResultHandler<Licensing.LicenseAssignments.Insert, LicenseAssignment, Uid>(){

                @Override
                public Uid handleResult(Licensing.LicenseAssignments.Insert request, LicenseAssignment value) {
                    LOG.ok("LicenseAssignment is Created:{0}/{1}/{2}", new Object[]{value.getProductId(), value.getSkuId(), value.getUserId()});
                    return LicenseAssignmentsHandler.generateUid(value);
                }
            });
        }
        throw new UnsupportedOperationException("Create of type " + this.objectClass.getObjectClassValue() + " is not supported");
    }
}

