/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.InMemoryPasswordEncoder;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.PasswordEncoderOutputFormatter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class UnsaltedMessageDigestInMemoryPasswordEncoder
extends InMemoryPasswordEncoder {
    private final int digestLengthBytes;
    @NotNull
    private final MessageDigest messageDigest;

    public UnsaltedMessageDigestInMemoryPasswordEncoder(@NotNull String prefix, @Nullable PasswordEncoderOutputFormatter outputFormatter, @NotNull MessageDigest messageDigest) {
        super(prefix, outputFormatter);
        Validator.ensureNotNull(messageDigest);
        this.messageDigest = messageDigest;
        this.digestLengthBytes = messageDigest.getDigestLength();
        Validator.ensureTrue(this.digestLengthBytes > 0, "The message digest use a fixed digest length, and that length must be greater than zero.");
    }

    @NotNull
    public String getDigestAlgorithm() {
        return this.messageDigest.getAlgorithm();
    }

    public int getDigestLengthBytes() {
        return this.digestLengthBytes;
    }

    @Override
    @NotNull
    protected byte[] encodePassword(@NotNull byte[] clearPassword, @NotNull ReadOnlyEntry userEntry, @NotNull List<Modification> modifications) throws LDAPException {
        return this.messageDigest.digest(clearPassword);
    }

    @Override
    protected void ensurePreEncodedPasswordAppearsValid(@NotNull byte[] unPrefixedUnFormattedEncodedPasswordBytes, @NotNull ReadOnlyEntry userEntry, @NotNull List<Modification> modifications) throws LDAPException {
        if (unPrefixedUnFormattedEncodedPasswordBytes.length != this.digestLengthBytes) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_UNSALTED_DIGEST_PW_ENCODER_PRE_ENCODED_LENGTH_MISMATCH.get(this.messageDigest.getAlgorithm(), unPrefixedUnFormattedEncodedPasswordBytes.length, this.digestLengthBytes));
        }
    }

    @Override
    protected boolean passwordMatches(@NotNull byte[] clearPasswordBytes, @NotNull byte[] unPrefixedUnFormattedEncodedPasswordBytes, @NotNull ReadOnlyEntry userEntry) throws LDAPException {
        byte[] expectedEncodedPassword = this.messageDigest.digest(clearPasswordBytes);
        return Arrays.equals(unPrefixedUnFormattedEncodedPasswordBytes, expectedEncodedPassword);
    }

    @Override
    @NotNull
    protected byte[] extractClearPassword(@NotNull byte[] unPrefixedUnFormattedEncodedPasswordBytes, @NotNull ReadOnlyEntry userEntry) throws LDAPException {
        throw new LDAPException(ResultCode.NOT_SUPPORTED, ListenerMessages.ERR_UNSALTED_DIGEST_PW_ENCODER_NOT_REVERSIBLE.get());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SaltedMessageDigestInMemoryPasswordEncoder(prefix='");
        buffer.append(this.getPrefix());
        buffer.append("', outputFormatter=");
        PasswordEncoderOutputFormatter outputFormatter = this.getOutputFormatter();
        if (outputFormatter == null) {
            buffer.append("null");
        } else {
            outputFormatter.toString(buffer);
        }
        buffer.append(", digestAlgorithm='");
        buffer.append(this.messageDigest.getAlgorithm());
        buffer.append("', digestLengthBytes=");
        buffer.append(this.messageDigest.getDigestLength());
        buffer.append(')');
    }
}

