/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.impl.migration.ProcessInstanceMigrationDocumentImpl;
import org.flowable.engine.migration.ActivityMigrationMapping;
import org.flowable.engine.migration.ProcessInstanceMigrationDocument;
import org.flowable.engine.migration.ProcessInstanceMigrationDocumentBuilder;
import org.flowable.engine.migration.Script;

public class ProcessInstanceMigrationDocumentBuilderImpl
implements ProcessInstanceMigrationDocumentBuilder {
    protected String migrateToProcessDefinitionId;
    protected String migrateToProcessDefinitionKey;
    protected Integer migrateToProcessDefinitionVersion;
    protected String migrateToProcessDefinitionTenantId;
    protected List<ActivityMigrationMapping> activityMigrationMappings = new ArrayList<ActivityMigrationMapping>();
    protected Map<String, Object> processInstanceVariables = new HashMap<String, Object>();
    protected Script preUpgradeScript;
    protected String preUpgradeJavaDelegate;
    protected String preUpgradeJavaDelegateExpression;
    protected Script postUpgradeScript;
    protected String postUpgradeJavaDelegate;
    protected String postUpgradeJavaDelegateExpression;

    @Override
    public ProcessInstanceMigrationDocumentBuilder setProcessDefinitionToMigrateTo(String processDefinitionId) {
        this.migrateToProcessDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder setProcessDefinitionToMigrateTo(String processDefinitionKey, Integer processDefinitionVersion) {
        this.migrateToProcessDefinitionKey = processDefinitionKey;
        this.migrateToProcessDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder setTenantId(String processDefinitionTenantId) {
        this.migrateToProcessDefinitionTenantId = processDefinitionTenantId;
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder setPreUpgradeScript(Script script) {
        this.preUpgradeScript = script;
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder setPreUpgradeJavaDelegate(String preUpgradeJavaDelegate) {
        this.preUpgradeJavaDelegate = preUpgradeJavaDelegate;
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder setPreUpgradeJavaDelegateExpression(String expression) {
        this.preUpgradeJavaDelegateExpression = expression;
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder setPostUpgradeScript(Script script) {
        this.postUpgradeScript = script;
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder setPostUpgradeJavaDelegate(String preUpgradeJavaDelegate) {
        this.postUpgradeJavaDelegate = preUpgradeJavaDelegate;
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder setPostUpgradeJavaDelegateExpression(String expression) {
        this.postUpgradeJavaDelegateExpression = expression;
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder addActivityMigrationMappings(List<ActivityMigrationMapping> activityMigrationMappings) {
        this.activityMigrationMappings.addAll(activityMigrationMappings);
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder addActivityMigrationMapping(ActivityMigrationMapping activityMigrationMapping) {
        this.activityMigrationMappings.add(activityMigrationMapping);
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder addProcessInstanceVariable(String variableName, Object variableValue) {
        this.processInstanceVariables.put(variableName, variableValue);
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocumentBuilder addProcessInstanceVariables(Map<String, Object> processInstanceVariables) {
        this.processInstanceVariables.putAll(processInstanceVariables);
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocument build() {
        if (this.migrateToProcessDefinitionId == null) {
            if (this.migrateToProcessDefinitionKey == null) {
                throw new FlowableException("Process definition key cannot be null");
            }
            if (this.migrateToProcessDefinitionVersion == null || this.migrateToProcessDefinitionVersion < 0) {
                throw new FlowableException("Process definition version must be a positive number");
            }
        }
        ProcessInstanceMigrationDocumentImpl document = new ProcessInstanceMigrationDocumentImpl();
        document.setMigrateToProcessDefinitionId(this.migrateToProcessDefinitionId);
        document.setMigrateToProcessDefinition(this.migrateToProcessDefinitionKey, this.migrateToProcessDefinitionVersion, this.migrateToProcessDefinitionTenantId);
        if (this.preUpgradeScript != null) {
            document.setPreUpgradeScript(this.preUpgradeScript);
        }
        if (this.preUpgradeJavaDelegate != null) {
            document.setPreUpgradeJavaDelegate(this.preUpgradeJavaDelegate);
        }
        if (this.preUpgradeJavaDelegateExpression != null) {
            document.setPreUpgradeJavaDelegateExpression(this.preUpgradeJavaDelegateExpression);
        }
        if (this.postUpgradeScript != null) {
            document.setPostUpgradeScript(this.postUpgradeScript);
        }
        if (this.postUpgradeJavaDelegate != null) {
            document.setPostUpgradeJavaDelegate(this.postUpgradeJavaDelegate);
        }
        if (this.postUpgradeJavaDelegateExpression != null) {
            document.setPostUpgradeJavaDelegateExpression(this.postUpgradeJavaDelegateExpression);
        }
        document.setActivityMigrationMappings(this.activityMigrationMappings);
        document.setProcessInstanceVariables(this.processInstanceVariables);
        return document;
    }
}

