/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.debug;

import java.util.Iterator;
import java.util.List;
import org.flowable.engine.debug.ExecutionTreeBfsIterator;
import org.flowable.engine.debug.ExecutionTreeNode;

public class ExecutionTree
implements Iterable<ExecutionTreeNode> {
    protected ExecutionTreeNode root;

    public ExecutionTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(ExecutionTreeNode root) {
        this.root = root;
    }

    public ExecutionTreeNode getTreeNode(String executionId) {
        return this.getTreeNode(executionId, this.root);
    }

    protected ExecutionTreeNode getTreeNode(String executionId, ExecutionTreeNode currentNode) {
        if (currentNode.getExecutionEntity().getId().equals(executionId)) {
            return currentNode;
        }
        List<ExecutionTreeNode> children = currentNode.getChildren();
        if (currentNode.getChildren() != null && children.size() > 0) {
            for (int index = 0; index < children.size(); ++index) {
                ExecutionTreeNode result = this.getTreeNode(executionId, children.get(index));
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public Iterator<ExecutionTreeNode> iterator() {
        return new ExecutionTreeBfsIterator(this.getRoot());
    }

    public ExecutionTreeBfsIterator bfsIterator() {
        return new ExecutionTreeBfsIterator(this.getRoot());
    }

    public ExecutionTreeBfsIterator leafsFirstIterator() {
        return new ExecutionTreeBfsIterator(this.getRoot(), true);
    }

    public String toString() {
        return this.root != null ? this.root.toString() : "";
    }
}

