/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.servicenow.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.tirasa.connid.bundles.servicenow.SNConnector;
import net.tirasa.connid.bundles.servicenow.dto.Resource;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;

public final class SNAttributes {
    public static final String RESOURCE_ATTRIBUTE_ID = "sys_id";
    public static final String USER_ATTRIBUTE_USERNAME = "user_name";
    public static final String RESOURCE_ATTRIBUTE_NAME = "name";

    public static Schema buildSchema() {
        SchemaBuilder builder = new SchemaBuilder(SNConnector.class);
        ObjectClassInfoBuilder userBuilder = new ObjectClassInfoBuilder().setType(ObjectClass.ACCOUNT_NAME);
        userBuilder.addAttributeInfo(Name.INFO);
        SNAttributes.buildAttributes(userBuilder);
        ObjectClassInfo user = userBuilder.build();
        builder.defineObjectClass(user);
        ObjectClassInfoBuilder groupBuilder = new ObjectClassInfoBuilder().setType(ObjectClass.GROUP_NAME);
        groupBuilder.addAttributeInfo(Name.INFO);
        SNAttributes.buildAttributes(groupBuilder);
        ObjectClassInfo group = groupBuilder.build();
        builder.defineObjectClass(group);
        return builder.build();
    }

    private static void buildAttributes(ObjectClassInfoBuilder builder) {
        for (String attributeName : Resource.asMapAttributeField().keySet()) {
            builder.addAttributeInfo(AttributeInfoBuilder.define((String)attributeName).build());
        }
    }

    public static AttributeBuilder buildAttributeFromClassField(Field field, String name, Object value) throws IllegalArgumentException, IllegalAccessException {
        return SNAttributes.doBuildAttributeFromClassField(name, value, field.getType());
    }

    public static AttributeBuilder doBuildAttributeFromClassField(String name, Object value, Class<?> clazz) {
        AttributeBuilder attributeBuilder = new AttributeBuilder();
        if (value != null) {
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                attributeBuilder.addValue(new Object[]{Boolean.class.cast(value)});
            } else if (value instanceof List) {
                ArrayList list = new ArrayList((List)value);
                if (list.size() > 1) {
                    for (Object elem : list) {
                        SNAttributes.doBuildAttributeFromClassField(name, elem, clazz);
                    }
                } else if (!list.isEmpty()) {
                    attributeBuilder.addValue(new Object[]{list.get(0).toString()});
                }
            } else {
                attributeBuilder.addValue(new Object[]{value.toString()});
            }
        }
        if (name != null) {
            attributeBuilder.setName(name);
        }
        return attributeBuilder;
    }
}

