/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.SAML2SPEntityTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.SAML2SPEntityDAO;
import org.apache.syncope.core.persistence.api.entity.am.SAML2SPEntity;
import org.apache.syncope.core.provisioning.api.data.SAML2SPEntityDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class SAML2SPEntityLogic
extends AbstractTransactionalLogic<SAML2SPEntityTO> {
    protected final SAML2SPEntityDataBinder binder;
    protected final SAML2SPEntityDAO entityDAO;

    public SAML2SPEntityLogic(SAML2SPEntityDataBinder binder, SAML2SPEntityDAO entityDAO) {
        this.binder = binder;
        this.entityDAO = entityDAO;
    }

    @PreAuthorize(value="hasRole('SAML2_SP_ENTITY_LIST')")
    @Transactional(readOnly=true)
    public List<SAML2SPEntityTO> list() {
        return this.entityDAO.findAll().stream().map(arg_0 -> ((SAML2SPEntityDataBinder)this.binder).getSAML2SPEntityTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('SAML2_SP_ENTITY_GET') or hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public SAML2SPEntityTO read(String key) {
        return Optional.ofNullable(this.entityDAO.find(key)).map(arg_0 -> ((SAML2SPEntityDataBinder)this.binder).getSAML2SPEntityTO(arg_0)).orElseThrow(() -> new NotFoundException(key + " not found"));
    }

    @PreAuthorize(value="hasRole('SAML2_SP_ENTITY_SET') or hasRole('ANONYMOUS')")
    public SAML2SPEntityTO set(SAML2SPEntityTO entityTO) {
        SAML2SPEntity entity = Optional.ofNullable(this.entityDAO.find(entityTO.getKey())).map(metadata -> this.binder.update(metadata, entityTO)).orElseGet(() -> this.binder.create(entityTO));
        return this.binder.getSAML2SPEntityTO(this.entityDAO.save(entity));
    }

    @PreAuthorize(value="hasRole('SAML2_SP_ENTITY_DELETE')")
    public void delete(String key) {
        Optional.ofNullable(this.entityDAO.find(key)).ifPresentOrElse(arg_0 -> ((SAML2SPEntityDAO)this.entityDAO).delete(arg_0), () -> {
            throw new NotFoundException(key + " not found");
        });
    }

    protected SAML2SPEntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof SAML2SPEntityTO)) continue;
                key = ((SAML2SPEntityTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getSAML2SPEntityTO(this.entityDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

