/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.proxy;

import java.util.Map;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;
import org.springmodules.cache.interceptor.caching.CachingListener;
import org.springmodules.cache.interceptor.caching.CachingModelSourceAdvisor;
import org.springmodules.cache.interceptor.caching.NameMatchCachingInterceptor;
import org.springmodules.cache.interceptor.flush.FlushingModelSourceAdvisor;
import org.springmodules.cache.interceptor.flush.NameMatchFlushingInterceptor;
import org.springmodules.cache.key.CacheKeyGenerator;
import org.springmodules.cache.provider.CacheProviderFacade;

public final class CacheProxyFactoryBean
extends ProxyConfig
implements FactoryBean,
InitializingBean {
    private static final long serialVersionUID = 3688501099833603120L;
    private NameMatchCachingInterceptor cachingInterceptor;
    private NameMatchFlushingInterceptor flushingInterceptor = new NameMatchFlushingInterceptor();
    private boolean hasFlushingModels;
    private Object proxy;
    private Class[] proxyInterfaces;
    private Object target;

    public CacheProxyFactoryBean() {
        this.cachingInterceptor = new NameMatchCachingInterceptor();
    }

    public void afterPropertiesSet() throws IllegalStateException, AopConfigException {
        this.cachingInterceptor.afterPropertiesSet();
        this.flushingInterceptor.afterPropertiesSet();
        if (this.target == null) {
            throw new IllegalStateException("Property 'target' is required");
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor((Advisor)new CachingModelSourceAdvisor(this.cachingInterceptor));
        if (this.hasFlushingModels) {
            proxyFactory.addAdvisor((Advisor)new FlushingModelSourceAdvisor(this.flushingInterceptor));
        }
        proxyFactory.copyFrom((ProxyConfig)this);
        TargetSource targetSource = this.createTargetSource(this.target);
        proxyFactory.setTargetSource(targetSource);
        if (this.proxyInterfaces != null) {
            proxyFactory.setInterfaces(this.proxyInterfaces);
        } else if (!this.isProxyTargetClass()) {
            if (this.target instanceof TargetSource) {
                throw new AopConfigException("Either 'proxyInterfaces' or 'proxyTargetClass' is required when using a TargetSource as 'target'");
            }
            proxyFactory.setInterfaces(ClassUtils.getAllInterfaces((Object)this.target));
        }
        this.proxy = proxyFactory.getProxy();
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        Class<?> objectType = null;
        if (this.proxy != null) {
            objectType = this.proxy.getClass();
        } else if (this.target != null && this.target instanceof TargetSource) {
            objectType = this.target.getClass();
        }
        return objectType;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setCacheKeyGenerator(CacheKeyGenerator cacheKeyGenerator) {
        this.cachingInterceptor.setCacheKeyGenerator(cacheKeyGenerator);
    }

    public void setCacheProviderFacade(CacheProviderFacade cacheProviderFacade) {
        this.flushingInterceptor.setCacheProviderFacade(cacheProviderFacade);
        this.cachingInterceptor.setCacheProviderFacade(cacheProviderFacade);
    }

    public void setCachingListeners(CachingListener[] cachingListeners) {
        this.cachingInterceptor.setCachingListeners(cachingListeners);
    }

    public void setCachingModels(Map cachingModels) {
        this.cachingInterceptor.setCachingModels(cachingModels);
    }

    public void setFlushingModels(Map flushingModels) {
        boolean bl = this.hasFlushingModels = flushingModels != null && !flushingModels.isEmpty();
        if (this.hasFlushingModels) {
            this.flushingInterceptor.setFlushingModels(flushingModels);
        } else {
            this.flushingInterceptor.setFlushingModelSource(null);
        }
    }

    public void setProxyInterfaces(String[] interfaceNames) throws ClassNotFoundException {
        this.proxyInterfaces = this.toInterfaceArray(interfaceNames);
    }

    private Class[] toInterfaceArray(String[] interfaceNames) throws ClassNotFoundException {
        Class[] interfaces = new Class[interfaceNames.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            interfaces[i] = ClassUtils.forName((String)interfaceNames[i].trim());
            if (interfaces[i].isInterface()) continue;
            throw new IllegalArgumentException("Can proxy only interfaces: [" + interfaces[i].getName() + "] is a class");
        }
        return interfaces;
    }

    public void setTarget(Object newTarget) {
        this.target = newTarget;
    }

    protected TargetSource createTargetSource(Object targetObject) {
        Object targetSource = null;
        targetSource = targetObject instanceof TargetSource ? (TargetSource)targetObject : new SingletonTargetSource(targetObject);
        return targetSource;
    }

    protected NameMatchCachingInterceptor getCachingInterceptor() {
        return this.cachingInterceptor;
    }

    protected NameMatchFlushingInterceptor getFlushingInterceptor() {
        return this.flushingInterceptor;
    }

    protected Object getProxy() {
        return this.proxy;
    }

    protected Class[] getProxyInterfaces() {
        return this.proxyInterfaces;
    }

    protected boolean isHasFlushingModels() {
        return this.hasFlushingModels;
    }
}

