/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classpath;

import java.util.LinkedHashSet;
import nonapi.io.github.classgraph.classpath.CallStackReader;
import nonapi.io.github.classgraph.reflection.ReflectionUtils;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;

public class ClassLoaderFinder {
    private final ClassLoader[] contextClassLoaders;

    public ClassLoader[] getContextClassLoaders() {
        return this.contextClassLoaders;
    }

    public static boolean classIsOrExtendsOrImplements(Class<?> cls, String className) {
        if (cls == null) {
            return false;
        }
        if (cls.getName().equals(className)) {
            return true;
        }
        if (ClassLoaderFinder.classIsOrExtendsOrImplements(cls.getSuperclass(), className)) {
            return true;
        }
        Class<?>[] classArray = cls.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            if (ClassLoaderFinder.classIsOrExtendsOrImplements(iface, className)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    ClassLoaderFinder(ScanSpec scanSpec, ReflectionUtils reflectionUtils, LogNode log) {
        LogNode classLoadersFoundLog;
        LinkedHashSet<Object> classLoadersUnique;
        if (scanSpec.overrideClassLoaders == null) {
            block12: {
                ClassLoader systemClassLoader;
                ClassLoader currClassClassLoader;
                classLoadersUnique = new LinkedHashSet();
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    classLoadersUnique.add(classLoader);
                }
                if ((currClassClassLoader = this.getClass().getClassLoader()) != null) {
                    classLoadersUnique.add(currClassClassLoader);
                }
                if ((systemClassLoader = ClassLoader.getSystemClassLoader()) != null) {
                    classLoadersUnique.add(systemClassLoader);
                }
                try {
                    Class<?>[] callStack = new CallStackReader(reflectionUtils).getClassContext(log);
                    int i = callStack.length - 1;
                    while (i >= 0) {
                        ClassLoader callerClassLoader = callStack[i].getClassLoader();
                        if (callerClassLoader != null) {
                            classLoadersUnique.add(callerClassLoader);
                        }
                        --i;
                    }
                }
                catch (IllegalArgumentException e) {
                    if (log == null) break block12;
                    log.log("Could not get call stack", e);
                }
            }
            if (scanSpec.addedClassLoaders != null) {
                classLoadersUnique.addAll(scanSpec.addedClassLoaders);
            }
            classLoadersFoundLog = log == null ? null : log.log("Found ClassLoaders:");
        } else {
            classLoadersUnique = new LinkedHashSet<ClassLoader>(scanSpec.overrideClassLoaders);
            LogNode logNode = classLoadersFoundLog = log == null ? null : log.log("Override ClassLoaders:");
        }
        if (classLoadersFoundLog != null) {
            for (ClassLoader classLoader : classLoadersUnique) {
                classLoadersFoundLog.log(classLoader.getClass().getName());
            }
        }
        this.contextClassLoaders = classLoadersUnique.toArray(new ClassLoader[0]);
    }
}

