/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.egrid.column.EditableGridActionsColumn;
import org.wicketstuff.egrid.component.EditableDataTable;
import org.wicketstuff.egrid.provider.IEditableDataProvider;
import org.wicketstuff.egrid.toolbar.EditableGridBottomToolbar;
import org.wicketstuff.egrid.toolbar.EditableGridHeadersToolbar;
import org.wicketstuff.egrid.toolbar.EditableGridNavigationToolbar;

public class EditableGrid<T, S>
extends Panel {
    private static final long serialVersionUID = 1L;
    private EditableDataTable<T, S> dataTable;

    public EditableGrid(String id, List<? extends IColumn<T, S>> columns, IEditableDataProvider<T, S> dataProvider, long rowsPerPage, Class<T> clazz) {
        super(id);
        ArrayList<Object> newCols = new ArrayList<Object>();
        newCols.addAll(columns);
        newCols.add(this.newActionsColumn());
        this.add(new Component[]{this.buildForm(newCols, dataProvider, rowsPerPage, clazz)});
    }

    private Component buildForm(List<? extends IColumn<T, S>> columns, IEditableDataProvider<T, S> dataProvider, long rowsPerPage, Class<T> clazz) {
        NonValidatingForm form = new NonValidatingForm("form");
        form.setOutputMarkupId(true);
        this.dataTable = this.newDataTable(columns, dataProvider, rowsPerPage, clazz);
        form.add(new Component[]{this.dataTable});
        return form;
    }

    public final EditableGrid<T, S> setTableBodyCss(String cssStyle) {
        this.dataTable.setTableBodyCss(cssStyle);
        return this;
    }

    public final EditableGrid<T, S> setTableCss(String cssStyle) {
        this.dataTable.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)cssStyle))});
        return this;
    }

    private EditableDataTable<T, S> newDataTable(List<? extends IColumn<T, S>> columns, IEditableDataProvider<T, S> dataProvider, long rowsPerPage, Class<T> clazz) {
        EditableDataTable dataTable = new EditableDataTable<T, S>("dataTable", columns, dataProvider, rowsPerPage, clazz){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onError(AjaxRequestTarget target) {
                EditableGrid.this.onError(target);
            }

            @Override
            protected Item<T> newRowItem(String id, int index, IModel<T> model) {
                return super.newRowItem(id, index, model);
            }
        };
        dataTable.setOutputMarkupId(true);
        dataTable.addTopToolbar(new EditableGridNavigationToolbar(dataTable));
        dataTable.addTopToolbar(new EditableGridHeadersToolbar(dataTable, dataProvider));
        if (this.displayAddFeature()) {
            dataTable.addBottomToolbar(this.newAddBottomToolbar(dataProvider, clazz, dataTable));
        }
        return dataTable;
    }

    protected EditableDataTable.RowItem<T> newRowItem(String id, int index, IModel<T> model) {
        return new EditableDataTable.RowItem<T>(id, index, model);
    }

    private EditableGridBottomToolbar<T, S> newAddBottomToolbar(final IEditableDataProvider<T, S> dataProvider, Class<T> clazz, final EditableDataTable<T, S> dataTable) {
        return new EditableGridBottomToolbar<T, S>(dataTable, clazz){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onAdd(AjaxRequestTarget target, T newRow) {
                dataProvider.add(newRow);
                target.add(new Component[]{dataTable});
                EditableGrid.this.onAdd(target, newRow);
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                EditableGrid.this.onError(target);
            }
        };
    }

    private EditableGridActionsColumn<T, S> newActionsColumn() {
        return new EditableGridActionsColumn<T, S>((IModel)new Model((Serializable)((Object)"Actions"))){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onError(AjaxRequestTarget target, IModel<T> rowModel) {
                EditableGrid.this.onError(target);
            }

            @Override
            protected void onSave(AjaxRequestTarget target, IModel<T> rowModel) {
                EditableGrid.this.onSave(target, rowModel);
            }

            @Override
            protected void onDelete(AjaxRequestTarget target, IModel<T> rowModel) {
                EditableGrid.this.onDelete(target, rowModel);
            }

            @Override
            protected void onCancel(AjaxRequestTarget target) {
                EditableGrid.this.onCancel(target);
            }

            @Override
            protected boolean allowDelete(Item<T> rowItem) {
                return EditableGrid.this.allowDelete(rowItem);
            }
        };
    }

    protected boolean allowDelete(Item<T> rowItem) {
        return true;
    }

    protected void onCancel(AjaxRequestTarget target) {
    }

    protected void onDelete(AjaxRequestTarget target, IModel<T> rowModel) {
    }

    protected void onSave(AjaxRequestTarget target, IModel<T> rowModel) {
    }

    protected void onError(AjaxRequestTarget target) {
    }

    protected void onAdd(AjaxRequestTarget target, T newRow) {
    }

    protected boolean displayAddFeature() {
        return true;
    }

    private static class NonValidatingForm<T>
    extends Form<T> {
        private static final long serialVersionUID = 1L;

        public NonValidatingForm(String id) {
            super(id);
        }

        public void process(IFormSubmitter submittingComponent) {
            this.delegateSubmit(submittingComponent);
        }
    }
}

