/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Product;

@PublicEvolving
public class ScalaCsvOutputFormat<T extends Product>
extends FileOutputFormat<T>
implements InputTypeConfigurable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ScalaCsvOutputFormat.class);
    public static final String DEFAULT_LINE_DELIMITER = "\n";
    public static final String DEFAULT_FIELD_DELIMITER = String.valueOf(",");
    private transient Writer wrt;
    private String fieldDelimiter;
    private String recordDelimiter;
    private String charsetName;
    private boolean allowNullValues = true;
    private boolean quoteStrings = false;

    public ScalaCsvOutputFormat(Path outputPath) {
        this(outputPath, DEFAULT_LINE_DELIMITER, DEFAULT_FIELD_DELIMITER);
    }

    public ScalaCsvOutputFormat(Path outputPath, String fieldDelimiter) {
        this(outputPath, DEFAULT_LINE_DELIMITER, fieldDelimiter);
    }

    public ScalaCsvOutputFormat(Path outputPath, String recordDelimiter, String fieldDelimiter) {
        super(outputPath);
        if (recordDelimiter == null) {
            throw new IllegalArgumentException("RecordDelmiter shall not be null.");
        }
        if (fieldDelimiter == null) {
            throw new IllegalArgumentException("FieldDelimiter shall not be null.");
        }
        this.fieldDelimiter = fieldDelimiter;
        this.recordDelimiter = recordDelimiter;
        this.allowNullValues = false;
    }

    public void setAllowNullValues(boolean allowNulls) {
        this.allowNullValues = allowNulls;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public void setQuoteStrings(boolean quoteStrings) {
        this.quoteStrings = quoteStrings;
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        super.open(taskNumber, numTasks);
        this.wrt = this.charsetName == null ? new OutputStreamWriter(new BufferedOutputStream((OutputStream)this.stream, 4096)) : new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)this.stream, 4096), this.charsetName);
    }

    public void close() throws IOException {
        if (this.wrt != null) {
            this.wrt.flush();
            this.wrt.close();
        }
        super.close();
    }

    public void writeRecord(T element) throws IOException {
        int numFields = element.productArity();
        for (int i = 0; i < numFields; ++i) {
            Object v = element.productElement(i);
            if (v != null) {
                if (i != 0) {
                    this.wrt.write(this.fieldDelimiter);
                }
                if (this.quoteStrings) {
                    if (v instanceof String || v instanceof StringValue) {
                        this.wrt.write(34);
                        this.wrt.write(v.toString());
                        this.wrt.write(34);
                        continue;
                    }
                    this.wrt.write(v.toString());
                    continue;
                }
                this.wrt.write(v.toString());
                continue;
            }
            if (this.allowNullValues) {
                if (i == 0) continue;
                this.wrt.write(this.fieldDelimiter);
                continue;
            }
            throw new RuntimeException("Cannot write tuple with <null> value at position: " + i);
        }
        this.wrt.write(this.recordDelimiter);
    }

    public String toString() {
        return "CsvOutputFormat (path: " + this.getOutputFilePath() + ", delimiter: " + this.fieldDelimiter + ")";
    }

    public void setInputType(TypeInformation<?> type, ExecutionConfig executionConfig) {
        if (!type.isTupleType()) {
            throw new InvalidProgramException("The " + ScalaCsvOutputFormat.class.getSimpleName() + " can only be used to write tuple data sets.");
        }
    }
}

