/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.List;
import org.apache.flink.runtime.executiongraph.EdgeManager;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;

public class IntermediateResultPartition {
    private final IntermediateResult totalResult;
    private final ExecutionVertex producer;
    private final IntermediateResultPartitionID partitionId;
    private final EdgeManager edgeManager;
    private boolean hasDataProduced = false;

    public IntermediateResultPartition(IntermediateResult totalResult, ExecutionVertex producer, int partitionNumber, EdgeManager edgeManager) {
        this.totalResult = totalResult;
        this.producer = producer;
        this.partitionId = new IntermediateResultPartitionID(totalResult.getId(), partitionNumber);
        this.edgeManager = edgeManager;
    }

    public ExecutionVertex getProducer() {
        return this.producer;
    }

    public int getPartitionNumber() {
        return this.partitionId.getPartitionNumber();
    }

    public IntermediateResult getIntermediateResult() {
        return this.totalResult;
    }

    public IntermediateResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public ResultPartitionType getResultType() {
        return this.totalResult.getResultType();
    }

    public List<ConsumerVertexGroup> getConsumerVertexGroups() {
        return this.getEdgeManager().getConsumerVertexGroupsForPartition(this.partitionId);
    }

    public List<ConsumedPartitionGroup> getConsumedPartitionGroups() {
        return this.getEdgeManager().getConsumedPartitionGroupsById(this.partitionId);
    }

    public void markDataProduced() {
        this.hasDataProduced = true;
    }

    public boolean isConsumable() {
        return this.hasDataProduced;
    }

    void resetForNewExecution() {
        if (this.getResultType().isBlocking() && this.hasDataProduced) {
            for (ConsumedPartitionGroup consumedPartitionGroup : this.getConsumedPartitionGroups()) {
                consumedPartitionGroup.partitionUnfinished();
            }
        }
        this.hasDataProduced = false;
        for (ConsumedPartitionGroup consumedPartitionGroup : this.getConsumedPartitionGroups()) {
            this.totalResult.clearCachedInformationForPartitionGroup(consumedPartitionGroup);
        }
    }

    public void addConsumers(ConsumerVertexGroup consumers) {
        this.getEdgeManager().connectPartitionWithConsumerVertexGroup(this.partitionId, consumers);
    }

    private EdgeManager getEdgeManager() {
        return this.edgeManager;
    }

    void markFinished() {
        if (!this.getResultType().isBlocking()) {
            throw new IllegalStateException("Tried to mark a non-blocking result partition as finished");
        }
        if (this.hasDataProduced) {
            throw new IllegalStateException("Tried to mark a finished result partition as finished.");
        }
        this.hasDataProduced = true;
        for (ConsumedPartitionGroup consumedPartitionGroup : this.getConsumedPartitionGroups()) {
            consumedPartitionGroup.partitionFinished();
        }
    }
}

