/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.ml;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkException$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.util.ConnectHelper;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.Summary;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.ml.MLCache$CacheItem$;
import org.apache.spark.sql.connect.ml.MLCacheSizeOverflowException;
import org.apache.spark.sql.connect.ml.MLModelSizeOverflowException;
import org.apache.spark.sql.connect.ml.MLUtils$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.util.SparkFileUtils$;
import org.json4s.JValue;
import org.json4s.JsonAssoc$;
import org.json4s.JsonDSL$;
import org.json4s.JsonListAssoc$;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tme!B\u001e=\u0001yB\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u000bu\u0003A\u0011\u00010\t\u000f\t\u0004!\u0019!C\u0005G\"11\u000e\u0001Q\u0001\n\u0011Dq\u0001\u001c\u0001C\u0002\u0013%Q\u000e\u0003\u0004w\u0001\u0001\u0006IA\u001c\u0005\bo\u0002\u0011\r\u0011\"\u0003n\u0011\u0019A\b\u0001)A\u0005]\"A\u0011\u0010\u0001b\u0001\n\u0003a$\u0010C\u0004\u0002\n\u0001\u0001\u000b\u0011B>\t\u0015\u0005-\u0001A1A\u0005\u0002q\ni\u0001\u0003\u0005\u0002\u0016\u0001\u0001\u000b\u0011BA\b\u0011)\t9\u0002\u0001EC\u0002\u0013\u0005\u0011\u0011\u0004\u0005\t\u0003W\u0001A\u0011\u0001\"\u0002.!9\u0011Q\u0007\u0001\u0005\n\u0005]\u0002\u0002CA \u0001\u0011\u0005A(a\u000e\u0007\u000f\u0005\u0005\u0003\u0001\u0011\u001f\u0002D!Q\u00111M\t\u0003\u0016\u0004%\t!!\u001a\t\u0015\u00055\u0014C!E!\u0002\u0013\t9\u0007\u0003\u0006\u0002pE\u0011)\u001a!C\u0001\u0003oA!\"!\u001d\u0012\u0005#\u0005\u000b\u0011BA\u001d\u0011\u0019i\u0016\u0003\"\u0001\u0002t!I\u0011QP\t\u0002\u0002\u0013\u0005\u0011q\u0010\u0005\n\u0003\u000b\u000b\u0012\u0013!C\u0001\u0003\u000fC\u0011\"!(\u0012#\u0003%\t!a(\t\u0011\u0005\r\u0016#!A\u0005B5D\u0011\"!*\u0012\u0003\u0003%\t!a*\t\u0013\u0005=\u0016#!A\u0005\u0002\u0005E\u0006\"CA_#\u0005\u0005I\u0011IA`\u0011%\ti-EA\u0001\n\u0003\ty\rC\u0005\u0002TF\t\t\u0011\"\u0011\u0002V\"I\u0011\u0011\\\t\u0002\u0002\u0013\u0005\u00131\u001c\u0005\n\u0003;\f\u0012\u0011!C!\u0003?D\u0011\"!9\u0012\u0003\u0003%\t%a9\b\u0015\u0005\u001d\b!!A\t\u0002q\nIO\u0002\u0006\u0002B\u0001\t\t\u0011#\u0001=\u0003WDa!\u0018\u0013\u0005\u0002\t\r\u0001\"CAoI\u0005\u0005IQIAp\u0011%\u0011)\u0001JA\u0001\n\u0003\u00139\u0001C\u0005\u0003\u000e\u0011\n\t\u0011\"!\u0003\u0010!Q!\u0011\u0005\u0001C\u0002\u0013\u0005AHa\t\t\u0011\tm\u0002\u0001)A\u0005\u0005KA\u0011B!\u0010\u0001\u0005\u0004%\t\u0001\u0010>\t\u000f\t}\u0002\u0001)A\u0005w\"A!\u0011\t\u0001\u0005\u0002\t\u000b9\u0004\u0003\u0005\u0003D\u0001!\tAQA\u001c\u0011\u001d\u0011)\u0005\u0001C\u0001\u0005\u000fBqAa\u0015\u0001\t\u0013\u0011)\u0006\u0003\u0005\u0003Z\u0001!\tA\u0011B.\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005GB\u0001Ba\u001a\u0001\t\u0003\u0011%\u0011\u000e\u0005\b\u0005[\u0002A\u0011\u0001B8\u0011\u001d\u0011\t\b\u0001C\u0001\u0005gBqAa\u001e\u0001\t\u0003\u0011I\bC\u0004\u0003\u0002\u0002!\tAa!\t\u0013\t%\u0005!%A\u0005\u0002\t-\u0005b\u0002BH\u0001\u0011\u0005\u00111\u001c\u0005\b\u0005#\u0003A\u0011\u0001BJ\u0005\u001diEjQ1dQ\u0016T!!\u0010 \u0002\u00055d'BA A\u0003\u001d\u0019wN\u001c8fGRT!!\u0011\"\u0002\u0007M\fHN\u0003\u0002D\t\u0006)1\u000f]1sW*\u0011QIR\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\u000b1a\u001c:h'\r\u0001\u0011j\u0014\t\u0003\u00156k\u0011a\u0013\u0006\u0002\u0019\u0006)1oY1mC&\u0011aj\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\u0005A\u001bV\"A)\u000b\u0005I\u0013\u0015\u0001C5oi\u0016\u0014h.\u00197\n\u0005Q\u000b&a\u0002'pO\u001eLgnZ\u0001\u000eg\u0016\u001c8/[8o\u0011>dG-\u001a:\u0004\u0001A\u0011\u0001lW\u0007\u00023*\u0011!LP\u0001\bg\u0016\u0014h/[2f\u0013\ta\u0016LA\u0007TKN\u001c\u0018n\u001c8I_2$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005}\u000b\u0007C\u00011\u0001\u001b\u0005a\u0004\"B+\u0003\u0001\u00049\u0016A\u00025fYB,'/F\u0001e!\t)\u0017.D\u0001g\u0015\t9\u0007.\u0001\u0003vi&d'BA\u001fC\u0013\tQgMA\u0007D_:tWm\u0019;IK2\u0004XM]\u0001\bQ\u0016d\u0007/\u001a:!\u0003!AW\r\u001c9fe&#U#\u00018\u0011\u0005=$X\"\u00019\u000b\u0005E\u0014\u0018\u0001\u00027b]\u001eT\u0011a]\u0001\u0005U\u00064\u0018-\u0003\u0002va\n11\u000b\u001e:j]\u001e\f\u0011\u0002[3ma\u0016\u0014\u0018\n\u0012\u0011\u0002%5|G-\u001a7DY\u0006\u001c8OT1nK\u001aKG.Z\u0001\u0014[>$W\r\\\"mCN\u001ch*Y7f\r&dW\rI\u0001\u001ei>$\u0018\r\\'M\u0007\u0006\u001c\u0007.Z%o\u001b\u0016lwN]=TSj,')\u001f;fgV\t1\u0010E\u0002}\u0003\u000bi\u0011! \u0006\u0003}~\fa!\u0019;p[&\u001c'\u0002BA\u0001\u0003\u0007\t!bY8oGV\u0014(/\u001a8u\u0015\t9'/C\u0002\u0002\bu\u0014!\"\u0011;p[&\u001cGj\u001c8h\u0003y!x\u000e^1m\u001b2\u001b\u0015m\u00195f\u0013:lU-\\8ssNK'0\u001a\"zi\u0016\u001c\b%\u0001\tiCN\u001c%/Z1uK\u0012lE\nR5sgV\u0011\u0011q\u0002\t\u0004y\u0006E\u0011bAA\n{\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0011\u0003[1t\u0007J,\u0017\r^3e\u001b2#\u0015N]:!\u0003IygM\u001a7pC\u0012,G-T8eK2\u001cH)\u001b:\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\u0005M&dWMC\u0002\u0002&I\f1A\\5p\u0013\u0011\tI#a\b\u0003\tA\u000bG\u000f[\u0001\u0018O\u0016$X*Z7pef\u001cuN\u001c;s_2,e.\u00192mK\u0012,\"!a\f\u0011\u0007)\u000b\t$C\u0002\u00024-\u0013qAQ8pY\u0016\fg.A\rhKRl\u0015\r_%o\u001b\u0016lwN]=DC\u000eDWmU5{K.\u0013UCAA\u001d!\rQ\u00151H\u0005\u0004\u0003{Y%\u0001\u0002'p]\u001e\f!dZ3u\u001f\u001a4Gn\\1eS:<G+[7f_V$X*\u001b8vi\u0016\u0014\u0011bQ1dQ\u0016LE/Z7\u0014\rEI\u0015QIA&!\rQ\u0015qI\u0005\u0004\u0003\u0013Z%a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u001b\niF\u0004\u0003\u0002P\u0005ec\u0002BA)\u0003/j!!a\u0015\u000b\u0007\u0005Uc+\u0001\u0004=e>|GOP\u0005\u0002\u0019&\u0019\u00111L&\u0002\u000fA\f7m[1hK&!\u0011qLA1\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\tYfS\u0001\u0004_\nTWCAA4!\ry\u0017\u0011N\u0005\u0004\u0003W\u0002(AB(cU\u0016\u001cG/\u0001\u0003pE*\u0004\u0013!C:ju\u0016\u0014\u0015\u0010^3t\u0003)\u0019\u0018N_3CsR,7\u000f\t\u000b\u0007\u0003k\nI(a\u001f\u0011\u0007\u0005]\u0014#D\u0001\u0001\u0011\u001d\t\u0019G\u0006a\u0001\u0003OBq!a\u001c\u0017\u0001\u0004\tI$\u0001\u0003d_BLHCBA;\u0003\u0003\u000b\u0019\tC\u0005\u0002d]\u0001\n\u00111\u0001\u0002h!I\u0011qN\f\u0011\u0002\u0003\u0007\u0011\u0011H\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tII\u000b\u0003\u0002h\u0005-5FAAG!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]5*\u0001\u0006b]:|G/\u0019;j_:LA!a'\u0002\u0012\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0015\u0016\u0005\u0003s\tY)A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003S\u00032ASAV\u0013\r\tik\u0013\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003g\u000bI\fE\u0002K\u0003kK1!a.L\u0005\r\te.\u001f\u0005\n\u0003wc\u0012\u0011!a\u0001\u0003S\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAa!\u0019\t\u0019-!3\u000246\u0011\u0011Q\u0019\u0006\u0004\u0003\u000f\\\u0015AC2pY2,7\r^5p]&!\u00111ZAc\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=\u0012\u0011\u001b\u0005\n\u0003ws\u0012\u0011!a\u0001\u0003g\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR\u0019a.a6\t\u0013\u0005mv$!AA\u0002\u0005%\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005%\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u00039\fa!Z9vC2\u001cH\u0003BA\u0018\u0003KD\u0011\"a/#\u0003\u0003\u0005\r!a-\u0002\u0013\r\u000b7\r[3Ji\u0016l\u0007cAA<IM)A%!<\u0002zBQ\u0011q^A{\u0003O\nI$!\u001e\u000e\u0005\u0005E(bAAz\u0017\u00069!/\u001e8uS6,\u0017\u0002BA|\u0003c\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\tYP!\u0001\u000e\u0005\u0005u(bAA\u0000e\u0006\u0011\u0011n\\\u0005\u0005\u0003?\ni\u0010\u0006\u0002\u0002j\u0006)\u0011\r\u001d9msR1\u0011Q\u000fB\u0005\u0005\u0017Aq!a\u0019(\u0001\u0004\t9\u0007C\u0004\u0002p\u001d\u0002\r!!\u000f\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0003B\u000f!\u0015Q%1\u0003B\f\u0013\r\u0011)b\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f)\u0013I\"a\u001a\u0002:%\u0019!1D&\u0003\rQ+\b\u000f\\33\u0011%\u0011y\u0002KA\u0001\u0002\u0004\t)(A\u0002yIA\n1bY1dQ\u0016$Wj\u001c3fYV\u0011!Q\u0005\t\t\u0005O\u0011IC!\f\u0002v5\tq0C\u0002\u0003,}\u0014QbQ8oGV\u0014(/\u001a8u\u001b\u0006\u0004\b\u0003\u0002B\u0018\u0005oqAA!\r\u00034A\u0019\u0011\u0011K&\n\u0007\tU2*\u0001\u0004Qe\u0016$WMZ\u0005\u0004k\ne\"b\u0001B\u001b\u0017\u0006a1-Y2iK\u0012lu\u000eZ3mA\u0005)Bo\u001c;bY6c5)Y2iKNK'0\u001a\"zi\u0016\u001c\u0018A\u0006;pi\u0006dW\nT\"bG\",7+\u001b>f\u0005f$Xm\u001d\u0011\u0002#\u001d,G/\u0014'DC\u000eDW-T1y'&TX-A\bhKRlu\u000eZ3m\u001b\u0006D8+\u001b>f\u00039\u0019\u0007.Z2l\u001b>$W\r\\*ju\u0016$BA!\u0013\u0003PA\u0019!Ja\u0013\n\u0007\t53J\u0001\u0003V]&$\bb\u0002B)_\u0001\u0007\u0011\u0011H\u0001\u0013KN$\u0018.\\1uK\u0012lu\u000eZ3m'&TX-\u0001\nfgRLW.\u0019;f\u001f\nTWm\u0019;TSj,G\u0003BA\u001d\u0005/Bq!a\u00191\u0001\u0004\t9'\u0001\fhKRlu\u000eZ3m\u001f\u001a4Gn\\1eS:<\u0007+\u0019;i)\u0011\tYB!\u0018\t\u000f\t}\u0013\u00071\u0001\u0003.\u0005)!/\u001a4JI\u0006A!/Z4jgR,'\u000f\u0006\u0003\u0003.\t\u0015\u0004bBA2e\u0001\u0007\u0011qM\u0001\u000fm\u0016\u0014\u0018NZ=PE*,7\r^%e)\u0011\u0011IEa\u001b\t\u000f\t}3\u00071\u0001\u0003.\u0005)1\r\\8tKR\u0011!\u0011J\u0001\u0004O\u0016$H\u0003BA4\u0005kBqAa\u00186\u0001\u0004\u0011i#\u0001\u0007`e\u0016lwN^3N_\u0012,G\u000e\u0006\u0004\u00020\tm$Q\u0010\u0005\b\u0005?2\u0004\u0019\u0001B\u0017\u0011\u001d\u0011yH\u000ea\u0001\u0003_\t\u0011\"\u001a<jGR|e\u000e\\=\u0002\rI,Wn\u001c<f)\u0019\tyC!\"\u0003\b\"9!qL\u001cA\u0002\t5\u0002\"\u0003B@oA\u0005\t\u0019AA\u0018\u0003A\u0011X-\\8wK\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u000e*\"\u0011qFAF\u0003\u0015\u0019G.Z1s\u0003\u001d9W\r^%oM>$\"A!&\u0011\u000b)\u00139J!\f\n\u0007\te5JA\u0003BeJ\f\u0017\u0010")
public class MLCache
implements Logging {
    private Path offloadedModelsDir;
    private volatile MLCache$CacheItem$ CacheItem$module;
    private final SessionHolder sessionHolder;
    private final ConnectHelper helper;
    private final String helperID;
    private final String modelClassNameFile;
    private final AtomicLong totalMLCacheInMemorySizeBytes;
    private final AtomicBoolean hasCreatedMLDirs;
    private final ConcurrentMap<String, CacheItem> cachedModel;
    private final AtomicLong totalMLCacheSizeBytes;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public MLCache$CacheItem$ CacheItem() {
        if (this.CacheItem$module == null) {
            this.CacheItem$lzycompute$1();
        }
        return this.CacheItem$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConnectHelper helper() {
        return this.helper;
    }

    private String helperID() {
        return this.helperID;
    }

    private String modelClassNameFile() {
        return this.modelClassNameFile;
    }

    public AtomicLong totalMLCacheInMemorySizeBytes() {
        return this.totalMLCacheInMemorySizeBytes;
    }

    public AtomicBoolean hasCreatedMLDirs() {
        return this.hasCreatedMLDirs;
    }

    /*
     * WARNING - void declaration
     */
    private Path offloadedModelsDir$lzycompute() {
        MLCache mLCache = this;
        synchronized (mLCache) {
            if (!this.bitmap$0) {
                void var3_3;
                Path dirPath = Paths.get(System.getProperty("java.io.tmpdir"), "spark_connect_model_cache", this.sessionHolder.sessionId());
                Path createdPath = Files.createDirectories(dirPath, new FileAttribute[0]);
                this.hasCreatedMLDirs().set(true);
                this.offloadedModelsDir = var3_3;
                this.bitmap$0 = true;
            }
        }
        return this.offloadedModelsDir;
    }

    public Path offloadedModelsDir() {
        if (!this.bitmap$0) {
            return this.offloadedModelsDir$lzycompute();
        }
        return this.offloadedModelsDir;
    }

    public boolean getMemoryControlEnabled() {
        return BoxesRunTime.unboxToBoolean((Object)this.sessionHolder.session().conf().get(Connect$.MODULE$.CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_ENABLED()));
    }

    private long getMaxInMemoryCacheSizeKB() {
        return BoxesRunTime.unboxToLong((Object)this.sessionHolder.session().conf().get(Connect$.MODULE$.CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_IN_MEMORY_SIZE())) / 1024L;
    }

    public long getOffloadingTimeoutMinute() {
        return BoxesRunTime.unboxToLong((Object)this.sessionHolder.session().conf().get(Connect$.MODULE$.CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_OFFLOADING_TIMEOUT()));
    }

    public ConcurrentMap<String, CacheItem> cachedModel() {
        return this.cachedModel;
    }

    public AtomicLong totalMLCacheSizeBytes() {
        return this.totalMLCacheSizeBytes;
    }

    public long getMLCacheMaxSize() {
        return BoxesRunTime.unboxToLong((Object)this.sessionHolder.session().conf().get(Connect$.MODULE$.CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_STORAGE_SIZE()));
    }

    public long getModelMaxSize() {
        return BoxesRunTime.unboxToLong((Object)this.sessionHolder.session().conf().get(Connect$.MODULE$.CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_MODEL_SIZE()));
    }

    public void checkModelSize(long estimatedModelSize) {
        if (this.totalMLCacheSizeBytes().get() + estimatedModelSize > this.getMLCacheMaxSize()) {
            throw new MLCacheSizeOverflowException(this.getMLCacheMaxSize());
        }
        if (estimatedModelSize > this.getModelMaxSize()) {
            throw new MLModelSizeOverflowException(estimatedModelSize, this.getModelMaxSize());
        }
    }

    private long estimateObjectSize(Object obj) {
        Object object = obj;
        if (object instanceof Model) {
            Model model = (Model)object;
            return model.estimatedSize();
        }
        throw new RuntimeException("Unexpected model object type.");
    }

    public Path getModelOffloadingPath(String refId) {
        Path path = this.offloadedModelsDir().resolve(refId);
        Predef$.MODULE$.require(path.startsWith(this.offloadedModelsDir()));
        return path;
    }

    public synchronized String register(Object obj) {
        String objectId = UUID.randomUUID().toString();
        if (obj instanceof Summary) {
            v0 = this.cachedModel().put(objectId, new CacheItem(this, obj, 0L));
        } else if (obj instanceof Model) {
            long l;
            if (this.getMemoryControlEnabled()) {
                long _sizeBytes = this.estimateObjectSize(obj);
                this.checkModelSize(_sizeBytes);
                l = _sizeBytes;
            } else {
                l = 0L;
            }
            long sizeBytes = l;
            this.cachedModel().put(objectId, new CacheItem(this, obj, sizeBytes));
            if (this.getMemoryControlEnabled()) {
                Path savePath = this.getModelOffloadingPath(objectId);
                ((MLWritable)obj).write().saveToLocal(((Object)savePath).toString());
                if (obj instanceof HasTrainingSummary && ((HasTrainingSummary)obj).hasSummary()) {
                    ((HasTrainingSummary)obj).saveSummary(((Object)savePath.resolve("summary")).toString());
                }
                Files.writeString(savePath.resolve(this.modelClassNameFile()), (CharSequence)obj.getClass().getName(), new OpenOption[0]);
                this.totalMLCacheInMemorySizeBytes().addAndGet(sizeBytes);
                v0 = BoxesRunTime.boxToLong((long)this.totalMLCacheSizeBytes().addAndGet(sizeBytes));
            } else {
                v0 = BoxedUnit.UNIT;
            }
        } else {
            throw new RuntimeException("'MLCache.register' only accepts model or summary objects.");
        }
        return objectId;
    }

    public void verifyObjectId(String refId) {
        try {
            UUID.fromString(refId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw SparkException$.MODULE$.internalError("The MLCache key " + refId + " is invalid.");
        }
    }

    public void close() {
        if (this.hasCreatedMLDirs().get() || this.cachedModel().size() > 0) {
            try {
                this.clear();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to cleanup ML cache resources"}))).log((Seq)Nil$.MODULE$)), throwable2);
                }
                throw throwable;
            }
            return;
        }
    }

    public synchronized Object get(String refId) {
        String string = refId;
        String string2 = this.helperID();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.helper();
        }
        this.verifyObjectId(refId);
        Object obj = Option$.MODULE$.apply(this.cachedModel().get(refId)).map((Function1 & Serializable)x$1 -> x$1.obj()).getOrElse((Function0 & Serializable)() -> null);
        if (obj == null && this.getMemoryControlEnabled()) {
            Path loadPath = this.getModelOffloadingPath(refId);
            if (Files.isDirectory(loadPath, new LinkOption[0])) {
                String className = Files.readString(loadPath.resolve(this.modelClassNameFile()));
                obj = MLUtils$.MODULE$.loadTransformer(this.sessionHolder, className, ((Object)loadPath).toString(), true);
                long sizeBytes = this.estimateObjectSize(obj);
                this.cachedModel().put(refId, new CacheItem(this, obj, sizeBytes));
                v1 = BoxesRunTime.boxToLong((long)this.totalMLCacheInMemorySizeBytes().addAndGet(sizeBytes));
            } else {
                v1 = BoxedUnit.UNIT;
            }
        } else {
            v1 = BoxedUnit.UNIT;
        }
        return obj;
    }

    public boolean _removeModel(String refId, boolean evictOnly) {
        boolean bl;
        boolean removedFromMem;
        this.verifyObjectId(refId);
        CacheItem removedModel = (CacheItem)this.cachedModel().remove(refId);
        boolean bl2 = removedFromMem = removedModel != null;
        if (!evictOnly && removedModel != null && this.getMemoryControlEnabled()) {
            this.totalMLCacheSizeBytes().addAndGet(-removedModel.sizeBytes());
            Path removePath = this.getModelOffloadingPath(refId);
            File offloadingPath = new File(((Object)removePath).toString());
            if (offloadingPath.exists()) {
                SparkFileUtils$.MODULE$.deleteRecursively(offloadingPath);
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        boolean removedFromDisk = bl;
        return removedFromMem || removedFromDisk;
    }

    public synchronized boolean remove(String refId, boolean evictOnly) {
        boolean modelIsRemoved = this._removeModel(refId, evictOnly);
        return modelIsRemoved;
    }

    public boolean remove$default$2() {
        return false;
    }

    public synchronized int clear() {
        int size;
        block0: {
            size = this.cachedModel().size();
            this.cachedModel().clear();
            this.totalMLCacheSizeBytes().set(0L);
            if (!this.getMemoryControlEnabled()) break block0;
            SparkFileUtils$.MODULE$.cleanDirectory(new File(((Object)this.offloadedModelsDir()).toString()));
        }
        return size;
    }

    public synchronized String[] getInfo() {
        ArrayBuilder info = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
        this.cachedModel().forEach((x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                CacheItem value = (CacheItem)tuple2._2();
                info.$plus$eq((Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JValue)JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc(JsonAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)key), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)value.obj().getClass().getName()), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToLong((long)value.sizeBytes())), (Function1 & Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)))), JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return (String[])info.result();
    }

    private final void CacheItem$lzycompute$1() {
        MLCache mLCache = this;
        synchronized (mLCache) {
            if (this.CacheItem$module == null) {
                this.CacheItem$module = new MLCache$CacheItem$(this);
            }
        }
    }

    public MLCache(SessionHolder sessionHolder) {
        this.sessionHolder = sessionHolder;
        Logging.$init$((Logging)this);
        this.helper = new ConnectHelper((SparkSession)sessionHolder.session());
        this.helperID = "______ML_CONNECT_HELPER______";
        this.modelClassNameFile = "__model_class_name__";
        this.totalMLCacheInMemorySizeBytes = new AtomicLong(0L);
        this.hasCreatedMLDirs = new AtomicBoolean(false);
        this.cachedModel = this.getMemoryControlEnabled() ? CacheBuilder.newBuilder().softValues().removalListener(removed -> this.totalMLCacheInMemorySizeBytes().addAndGet(-((CacheItem)removed.getValue()).sizeBytes())).maximumWeight(this.getMaxInMemoryCacheSizeKB()).weigher((key, value) -> (int)Math.ceil((double)value.sizeBytes() / (double)1024)).expireAfterAccess(this.getOffloadingTimeoutMinute(), TimeUnit.MINUTES).build().asMap() : new ConcurrentHashMap<String, CacheItem>();
        this.totalMLCacheSizeBytes = new AtomicLong(0L);
    }

    public class CacheItem
    implements Product,
    Serializable {
        private final Object obj;
        private final long sizeBytes;
        public final /* synthetic */ MLCache $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Object obj() {
            return this.obj;
        }

        public long sizeBytes() {
            return this.sizeBytes;
        }

        public CacheItem copy(Object obj, long sizeBytes) {
            return new CacheItem(this.org$apache$spark$sql$connect$ml$MLCache$CacheItem$$$outer(), obj, sizeBytes);
        }

        public Object copy$default$1() {
            return this.obj();
        }

        public long copy$default$2() {
            return this.sizeBytes();
        }

        public String productPrefix() {
            return "CacheItem";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.obj();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.sizeBytes());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheItem;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "obj";
                }
                case 1: {
                    return "sizeBytes";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)1450061205);
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.obj()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sizeBytes()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheItem)) return false;
            if (((CacheItem)object).org$apache$spark$sql$connect$ml$MLCache$CacheItem$$$outer() != this.org$apache$spark$sql$connect$ml$MLCache$CacheItem$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheItem cacheItem = (CacheItem)x$1;
            if (this.sizeBytes() != cacheItem.sizeBytes()) return false;
            if (!BoxesRunTime.equals((Object)this.obj(), (Object)cacheItem.obj())) return false;
            if (!cacheItem.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MLCache org$apache$spark$sql$connect$ml$MLCache$CacheItem$$$outer() {
            return this.$outer;
        }

        public CacheItem(MLCache $outer, Object obj, long sizeBytes) {
            this.obj = obj;
            this.sizeBytes = sizeBytes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

